import request from 'mn-template/plugins/http';
//  获取检测详情 接口
export const getDetectionDetail = (id) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/record/info/?detectionRecordId=${id}&userType=0`,
    withCredentials: true,
  });
};

// 检测详情节点查询
export const getDetectionDetailProces = (id) => {
  return request({
    method: 'get',
    url: `/trade/detection/record/process/${id}`,
    withCredentials: true,
  });
};

// 发送报告到钉钉工作站
export const sendReportWorkStation = (data) => {
  return request({
    method: 'get',
    url: `/store/admin/hospital/detection/reportShare/${data.id}?reportType=${data.reportType}`,
    withCredentials: true,
  });
};

// 获取报告
export const sendReportShareInfo = (data) => {
  return request({
    method: 'get',
    url: `/store/admin/hospital/detection/reportShareInfo/${data.id}?reportType=${data.reportType}`,
    withCredentials: true,
  });
};
//  获取阳性报告类型列表
export const getTypeCodeList = () => {
  return request({
    url: 'basic-data/constants/app?typeCodeList=P326',
    method: 'get',
    withCredentials: true,
  });
};
//  跟进报告提交
// /trade/detection/record/operation/submit

export const operationSubmit = (data) => {
  return request({
    method: 'post',
    url: '/trade/detection/record/operation/submit',
    data: data,
    withCredentials: true,
  });
};
