import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import insuranceBindCode from '@/views/insurance-bind-code/insurance-bind-code';
import insuranceDetectionDetail from '@/views/insurance-detection-detail/insurance-detection-detail';
import handleAllRouter from '../public_uat';

const routerConfig = [
  {
    path: '/insuranceBindCode',
    name: 'insuranceBindCode',
    component: insuranceBindCode
  },
  {
    path: '/insuranceDetectionDetail',
    name: 'insuranceDetectionDetail',
    component: insuranceDetectionDetail
  },
  {
    path: '/result',
    name: 'result',
    component: () => import('@/views/result/index.vue'),
  },
  {
    path: '/result-risk',
    name: 'resultRisk',
    component: () => import('@/views/result/risk.vue'),
  },
  {
    path: '/appoint',
    name: 'appoint',
    component: () => import('@/views/appoint/index.vue'),
  },
];

router.beforeEach(async (to, from, next) => {
  next();
});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
