import Cookies from 'js-cookie';
const VUE_APP_ENV = process.env.VUE_APP_ENV;
const VUE_APP_DOMAIN = process.env.VUE_APP_DOMAIN;
const localDomain = VUE_APP_ENV === 'development' ? window.location.hostname : VUE_APP_DOMAIN;

export const setCookie = (
  cname,
  cvalue,
  params = {
    path: '/',
    expires: 7,
    domain: localDomain,
  },
) => {
  delCookie(cname);
  Cookies.set(cname, cvalue, params);
};

export const getCookie = (
  cname,
  params = { path: '/', domain: localDomain },
) => {
  const data = Cookies.get(cname, params);
  return data;
};

export const delCookie = (cname) => {
  Cookies.remove(cname, {
    path: '/',
    domain: localDomain,
  });
  Cookies.remove(cname, {
    path: '/',
    domain: '.yunqueyi.com',
  });
  Cookies.remove(cname, {
    path: '/',
  });
};
