#!/bin/bash
hasGit=`which git` # 判断是否存在git
msg=${1:-'auto commit'} # 获取终端输入的第一个参数，若为空则为auto commit
originBranch='origin/release'
if [ ! $hasGit ];then
  echo 'Please download git first!';
  exit 1;
else
  git remote update
  git fetch --all
  result=`git symbolic-ref --short -q HEAD` # 获取分支名
  diff=`git diff $result $originBranch | grep -i ">>>>>>"`
  empty=""
  if test $diff -eq $empty
  then
    current_id=`git log -n 1 $originBranch --pretty=format:"%H"`
    echo "没有冲突，继续"
    echo "远程目标分支: $originBranch "
    echo "远程目标分支最新commit: $current_id"
    git reset --soft $current_id
    git add .
    git commit -m "$msg"
    git push origin  --force-with-lease $result # 提交代码到github(修改了远程项目名)
  else
    git add .
    git commit -m "auto commit"
    git push origin $result
    echo "本地分支和origin/release存在冲突"
    echo "result: $result $diff"
  fi
fi