import {
  router,
  store,
  vueApp,
} from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import * as dd from 'dingtalk-jsapi';
import '@/router';
console.log('router, store, vueApp: ', router, store, vueApp);
import '@/assets/js/flexible';
import { isWeixin } from './utils/index';
import Loading from '@/components/loading/loading.js';
import CryptoJS from 'crypto-js/crypto-js';
import JsEncrypt from 'jsencrypt/bin/jsencrypt';

// 禁用双指放大
window.JSEncrypt = JsEncrypt;
window.CryptoJS = CryptoJS;
var lastTouchEnd = 0;
document.addEventListener('touchstart', function (event) {
  if (event.touches.length > 1) {
    event.preventDefault();
  }
});
document.addEventListener(
  'touchend',
  function (event) {
    var now = new Date().getTime();
    if (now - lastTouchEnd <= 300) {
      event.preventDefault();
    }
    lastTouchEnd = now;
  },
  false
);
document.documentElement.addEventListener(
  'touchstart',
  function (event) {
    if (event.touches.length > 1) {
      event.preventDefault();
    }
  },
  {
    passive: false,
  }
);
console.log('z', vueApp.$rocNative);
vueApp.$rocNative.appInit();
vueApp.$rocNative.on('wx_ready', function () {
  console.log('-wx_ready-', window._picaWechat);
  // 初始化wx jssdk 后 执行 脚手架将 wx 对象挂在到 $rocNative对象上，后执行  小程序环境判断方法 miniProgram.getEnv
  vueApp.$rocNative.WXInstance.miniProgram.getEnv(function (res) {
    console.log('_miniprogram', res.miniprogram); // true
    window._miniprogram = res.miniprogram;
  });
});
console.log('---', isWeixin());
if (isWeixin()) {
  window._picaWechat = 'wechat';
}
if (dd.env.version) {
  window._picaWechat = 'dingtalk';
}

sessionStorage.setItem('headerHeight', 0);

window.Vue.use(Loading);
// 设置安全密钥
window._AMapSecurityConfig = {
  securityJsCode: 'f5093bfce95bd0393749259bcc44ede8',
};

console.log('router, store, vueApp: ', router, store, vueApp);
console.log('window :>> ', window);
