import { router } from '@pica-cli/vue-cli-plugin-pica-cli-plugin/auto';
import insuranceBindCode from '@/views/insurance-bind-code/insurance-bind-code';
import insuranceDetectionDetail from '@/views/insurance-detection-detail/insurance-detection-detail';
import {toggleSkeletonRouter} from 'mn-template/plugins/toggleSkeleton.js';
import handleAllRouter from '../public_uat';

const routerConfig = [
  {
    path: '/insuranceBindCode',
    name: 'insuranceBindCode',
    component: insuranceBindCode
  },
  {
    path: '/insuranceDetectionDetail',
    name: 'insuranceDetectionDetail',
    component: insuranceDetectionDetail
  },
  {
    path: '*',
    redirect: process.env.VUE_APP_BASE_ROUTE
  }
];

router.beforeEach(async (to, from, next) => {
  toggleSkeletonRouter(to, from);
  next();
});

router.addRoutes(routerConfig);

if (process.env.VUE_APP_ENV == 'uat') {
  const routerInfo = {
    routerConfig: routerConfig,
  };
  handleAllRouter(routerInfo);
}
