import request from 'mn-template/plugins/http';

// 获取权益列表
export const getEntitlementList = async (externalOrderNo, projectEquityNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/projectEquityNo/externalOrderNo?externalOrderNo=${externalOrderNo}&projectEquityNo=${projectEquityNo}`,
    withCredentials: true,
    // hasLoading: true,
  });
};

// 获取banner
export const getBanner = async (pageType, yunOrderNo) => {
  return request({
    method: 'get',
    url: `/tis/insurance/explain/${yunOrderNo}/${pageType}`,
    withCredentials: true,
    // hasLoading: true,
  });
};

// 查询证件类型字典的接口
export const getCardTypes = () => {
  return request({
    url: 'basic-data/constants/app?typeCodeList=P333',
    method: 'get',
    withCredentials: true,
  });
};

export const projectMaterial = () => {
  return request({
    url: 'basic-data/constants/app/no-chars/P336',
    method: 'get',
    withCredentials: true,
  });
};

export const getRequestParm = (params) => {
  return request({
    url: '/tis/insurance/common/shaoxing/requestParm',
    method: 'get',
    params,
    withCredentials: true,
  });
};

export const getInsProjectInfo = (params) => {
  return request({
    url: '/activity/act/projectInfo',
    method: 'get',
    params,
    withCredentials: true,
  });
};

export const getActivityInfo = (params) => {
  return request({
    url: '/activity/act/check',
    method: 'post',
    params,
    withCredentials: true,
  });
};

export const insuranceStatusCheck = (params) => {
  return request({
    url: '/tis/insurance/merchant/check/projectOpened',
    method: 'get',
    params,
    withCredentials: true,
  });
};
