# pica-insurance
> 请先查看每个目录的 md 文件

## 仓库入口
[pica-insurance](http://192.168.110.53/com.pica.cloud.frontend/pica-insurance)

## 启动
```shell script
npm run start
```

## 编译打包
```shell script
#开发环境
npm run build:dev
#预发环境
npm run build:pre
#生产环境
npm run build:prod
#测试环境
npm run build:test
```

## 插件配置
```js
module.exports = {
    // 插件配置项
    pluginOptions: {
        // 蛮牛配置
        pica: {
            // CDN扩展JS资源排序: ['lodash', 'vue', 'vuex']
            jsSort: [],
            // CDN扩展CSS资源排序: ['vant.css']
            cssSort: [],
            // 骨架屏渲染的路由（手动配置）
            skeletonRoutes: [
                {
                  path: '/demo',
                  name: 'Demo',
                  meta: {
                    skeleton: true
                  }
                },
            ],
            // 启用自动配置骨架屏渲染路由
            enableAutoSkeletonRoutes: false,
            // 路由模式
            routeMode: 'history',
            // 骨架屏一次渲染几个路由
            dpsLimit: 5,
            // dps骨架屏渲染本地服务配置
            dpsServer: {}
        },
        // 图片压缩
        tinypng: {
            key: ''
        },
        // 自动路由配置
        autoRouting: {
            chunkNamePrefix: 'page-'
        }
    }
};

```

## dpsServer
### port
服务监听端口，默认从8000开始查找可用端口

### proxy
反向代理中间件配置 @See [http-proxy-middleware](https://github.com/chimurai/http-proxy-middleware)
如果需要自定义返回:
```js
{
    proxy: {
        '^/app-gateway': (req, res, next) => {
            res.json({ code: 200, data: {} });
            res.end();
        }
    }   
}
```

## 图片压缩
> 需要在`vue.config.js`中配置`pluginOptions.tinypng.key`的值。
```shell script
npm run tinypng
```

## 调用生成器
```shell script
vue invoke pica
```

## 根据 pica.prompts 生成封闭式模板
```shell script
npm run core
```

## 使用骨架屏
> 框架默认已开启骨架屏渲染。请查看`vue.config.js`

### 自动根据路由配置
需要在路由页面文件配置`route`块
```json
{
    "meta": {
        "skeleton": true
    }
}
```
如需自定义骨架
```json
{
    "meta": {
        "skeleton": {
            "name": "必须和路由定义的name一致", 
            "path": "匹配当前路由的正则", 
            "pathname": "访问路由的path地址，例如: /mn/demo", 
            "skeletonId": "骨架屏路由ID，唯一即可"
        }
    }
}
```

## Jenkinsfile 构建

在 Jenkinsfile 文件中 `versionType = 'Patch';`，versionType 默认为 Patch，为小版本更新，1.2.3 对应 Major.Minor.Patch。

```bash
npm run build:test versionType:Patch
```

## 后台API接口反向代理
### 本地
如果`VUE_APP_MOCK_USER_INFO`不为空则走代理到本地。并且会在接口地址前加上`/proxy`.
默认会把`/proxy`的接口代理到`http://localhost:8081。

如需修改，请查看项目根目录的`.proxy.js`文件

### 走网关
如果`VUE_APP_MOCK_USER_INFO`为空则走代理到网关。并且会在接口地址前加上`/proxy/app-gateway`.
会把`/proxy`的接口代理到`VUE_APP_SERVICE_URL`环境变量，如该变量为空则默认为``
