const path = require('path');
const axios = require('axios');
const fs = require('fs');
const projectName = require('./package.json').name;
const filePath = path.join(__dirname, 'src');

// 先删除文件
function deleOldJson() {
    const json_path = path.join(__dirname, 'src/menu_code.json');
    try{
      fs.unlinkSync(json_path);
    }catch(err) {
      console.log('没有json 文件');
    }
}
deleOldJson();
// 文件夹是不是存在
function isFileExisted(filePath) {
    return new Promise((resolve, reject) => {
      fs.access(filePath, (err) => {
        if (err) {
          return reject(false);
        } else {
          return resolve(true);
        }
      });
    });
}
// 请求接口获取menucode
function getMenuCode() {
    const url = 'https://sc.yunqueyi.com/basic-data/menuCode/fetch';
    // let url="https://dev-sc.yunqueyi.com/basic-data/menuCode/fetch";
    console.log(projectName);
    axios.get(url, {params:{'projectName':projectName}})
    .then(res => {
      const resData = res.data;
       if(resData.code == '000000') {
          if(!resData.data) {
            console.log('接口data 数据为空');
            return;
          }
          console.log('-- ', resData.data.menuCodeDtoList);
          return writerJsonFile(JSON.stringify(resData.data.menuCodeDtoList));
       }else{
          console.log('获取接口失败');
       }
    }).catch(error => {
        console.error('请求menu接口失败error', error);
    });
}
// 写入json 文件
function writerJsonFile(data) {
    const wpath = filePath + '/menu_code.json';
    fs.writeFileSync(wpath, data);
    console.log('写入文件成功');
}
// 创建目录
function createFiles(filePath) {
        fs.mkdir(filePath, function(err) {
            if(!err) {
               getMenuCode();
            }else{
               console.log('创建目录失败');
            }
        });
}
isFileExisted(filePath).then(() => {
  return getMenuCode();
}).catch(() => {
    // 没有文件创建文件
    createFiles(filePath);
});
