package com.pica.cloud.online.exam.analysis.server.controller;

import com.pica.cloud.online.exam.analysis.server.entity.Doctor;
import com.pica.cloud.online.exam.analysis.server.mapper.DoctorMapper;
import com.pica.cloud.online.exam.analysis.server.entity.Reply;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.pica.cloud.online.exam.analysis.server.client.IConfigServiceClient;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.RedisClient;

@RestController
@RequestMapping("/demo")
@Api(value = "冒烟测试", description = "测试 db，redis，读取自定义配置 以及使用 feign 调用微服务")
public class DemoController {
    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private RedisClient redisClient;

    @Autowired
    private PropertiesConfiguration properties;

    @Autowired
    private LoadBalancerClient slb;

    @Autowired
    private IConfigServiceClient client;

    @ApiOperation(value = "DB连接测试：更新Person对象", response = PicaResponse.class)
    @RequestMapping(value = "/db", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<Reply> saveToDB() {
        // 创建一个ResponseBuilder
        PicaResponse.Builder<Doctor> builder = new PicaResponse.Builder<>();

        //PICAUser picaUser = CommonUtils.getUserByToken(redisClient, "FDE7216893B249E0BDE7F7260D36E167");

        builder.setData(doctorMapper.selectByPrimaryKey(100548471));

        // 返回Response
        return builder.build();
    }

    /*@ApiOperation(value = "Redis连接测试：插入一个Person对象到Redis", response = PicaResponse.class)
    @RequestMapping(value = "/redis", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<String> saveToCache() {
        PicaResponse.Builder<String> builder = new PicaResponse.Builder<>();

        redisClient.set("keyname", personMapper.selectByPrimaryKey(1008));

        return builder.setData(redisClient.get("keyname")).build();
    }
*/
    @ApiOperation(value = "读取配置测试", response = PicaResponse.class)
    @RequestMapping(value = "/config", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<String> readFromConfiguration() {
        PicaResponse.Builder<String> builder = new PicaResponse.Builder<>();

        builder.setData(properties.toString());

        return builder.build();
    }

    @ApiOperation(value = "Feign调用微服务", response = PicaResponse.class)
    @RequestMapping(value = "/beans", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public String beans() {
        return client.beans();
    }
}
