package com.pica.cloud.online.exam.analysis.server.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author wuminghao
 * @date 2018/9/1 10:54
 */
public class DateUtils {
    private static final long ONE_MINITE = 60;
    private static final long ONE_HOUR = 3600;
    private static final long ONE_DAY = 86400;
    private static final long THREE_DAY = 259200;

    public static Calendar calendar = Calendar.getInstance();

    public static String fromNow(Date date) {
        calendar.setTime(date);

        long time = date.getTime() / 1000;
        long now = (new Date()).getTime() / 1000;
        long interval = now - time;

        if (interval <= ONE_MINITE) {
          return "刚刚发布";
        } else if (interval <= ONE_HOUR) {
            return interval / ONE_MINITE + "分钟前";
        } else if (interval <= ONE_DAY) {
            return interval / ONE_HOUR + "小时前";
        } else if (interval < THREE_DAY) {
            return interval / ONE_DAY + "天前";
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String remainingTime(Date date) {
        long time = date.getTime() / 1000;
        long now = (new Date()).getTime() / 1000;
        long interval = now - time;

        if (interval < 0)
            return "";

        if (interval <= ONE_MINITE) {
            return "1分钟";
        } else if (interval <= ONE_HOUR) {
            return interval / ONE_MINITE + "分钟";
        } else if (interval <= ONE_DAY) {
            return interval / ONE_HOUR + "小时" + (interval % ONE_HOUR) / ONE_MINITE + "分钟";
        } else {
            return interval / ONE_DAY + "天" +
                    (interval % ONE_DAY) / ONE_HOUR + "小时" +
                    ((interval % ONE_DAY) % ONE_HOUR) / ONE_MINITE + "分钟";
        }
    }
}
