package com.pica.cloud.online.exam.analysis.server.mapper;

import com.pica.cloud.online.exam.analysis.server.entity.Reply;

import java.util.List;
import java.util.Map;

public interface ReplyMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(Reply record);

    int insertSelective(Reply record);

    Reply selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(Reply record);

    int updateByPrimaryKey(Reply record);

    int selectReplyCountByAnalysisRoundExamTitleId(Integer analysisRoundExamTitleId);

    int selectReplyCountByRecord(Reply record);

    Reply selectReplyByRecord(Reply record);

    List<Reply> selectReplyListByAnalysisRoundExamTitleId(Integer analysisRoundExamTitleId);

    /**
     * 按照时间逆序获取
     * @param analysisRoundExamTitleId
     * @return
     */
    List<Reply> selectReplyListOrderByTime(Integer analysisRoundExamTitleId);

    /**
     * 获取最热的五条记录
     * @param analysisRoundExamTitleId
     * @return
     */
    List<Reply> selectFiveHottestReplyList(Integer analysisRoundExamTitleId);

    /**
     * 根据话题id获取当选的票数
     * @param examTitleIds
     * @return
     */
    Integer selectElectedStarCountByExamTitleIdList(List<Integer> examTitleIds);

    /**
     * 根据话题id获取当选的医生id
     * @param examTitleIds
     * @return
     */
    Integer selectElectedDoctorIdByExamTitleIdList(List<Integer> examTitleIds);

    /**
     * 获取某人某轮的获赞数
     * @param param
     * @return
     */
    Integer selectStarCountByParam(Map param);

    /**
     * 获取某人某轮的获赞记录
     * @param param
     * @return
     */
    List<Reply> selectStarRecordByParam(Map param);
}