package com.pica.cloud.online.exam.analysis.common;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.foundation.redis.RedisClient;
import com.pica.cloud.foundation.utils.entity.PICAUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @Auther wangyongbo
 * @Date 2018/6/8 下午7:10
 */
public class CommonUtils {
    private static Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    /**
     * @param map
     * @return
     */
    public static PICAUser getUser(Map<String, String> map) {
        if (map.isEmpty()) {
            return null;
        }
        return JSON.parseObject(JSON.toJSONString(map), PICAUser.class);
    }

    public static PICAUser getUserByToken(RedisClient client, String token) {
        PICAUser picaUser = null;
        try {
            picaUser = CommonUtils.getUser(client.getToken(token));
        } catch (Exception e) {
            logger.error("根据token获取user失败：" + token);
        }
        return picaUser;
    }
}
