package com.pica.cloud.online.exam.analysis.server.client;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author wuminghao
 * @date 2018/9/30 10:01
 */
@FeignClient(value="10901-PICA-CLOUD-ONLINEEXAM")
public interface IOnlineExamServiceClient {

    /**
     * 调用
     * @param onlineExamId
     * @param sysCode
     * @param token
     * @return
     */
    @RequestMapping(value="/getExamStatus", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    String getExamStatus(@RequestParam(value = "onlineExamId") Integer onlineExamId,
                         @RequestParam(value = "code") Integer code,
                        @RequestHeader(value = "sysCode") String sysCode,
                        @RequestHeader(value = "token") String token);
}
