package com.pica.cloud.online.exam.analysis.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.RedisClient;
import com.pica.cloud.foundation.utils.entity.PICAUser;
import com.pica.cloud.online.exam.analysis.common.CommonUtils;
import com.pica.cloud.online.exam.analysis.common.constants.CommonConstants;
import com.pica.cloud.online.exam.analysis.common.dto.*;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.client.IConfigServiceClient;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.online.exam.analysis.server.entity.*;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import com.pica.cloud.online.exam.analysis.server.service.CHCAnalysisService;
import com.pica.cloud.online.exam.analysis.server.service.CHCRankingListService;
import com.pica.cloud.online.exam.analysis.server.service.DoctorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javassist.bytecode.ExceptionsAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author wuminghao
 * @date 2018/8/16 18:10
 */
@RestController
@RequestMapping("/")
@Api(value = "题目分析接口", description = "查看活动及详情，用户点赞、医生回复")
public class AnalysisController {
    @Autowired
    private RedisClient redisClient;

    @Autowired
    private LoadBalancerClient slb;

    @Autowired
    private IConfigServiceClient client;

    @Autowired
    private CHCAnalysisService analysisService;

    @Autowired
    private DoctorService doctorService;

    @Autowired
    private AntiSpamService antiSpamService;

    @Autowired
    private CHCRankingListService rankingListService;

    @ApiOperation(value = "获取活动详情", response = PicaResponse.class)
    @RequestMapping(value = "/activityDetail", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<CHCAnalysisDto> getActivityDetail(@RequestParam(required = false) Integer id) {
        PicaResponse.Builder<CHCAnalysisDto> builder = new PicaResponse.Builder<>();

        /**
         * 如果不传活动id进来，活动id就用1
         */
        id = (id == null ? 1 : id);

        try {
            CHCAnalysisDto analysisDto = analysisService.getCHCAnalysisDtoById(id);
            List<AnalysisRoundDto> roundList = analysisService.getRoundListByAnalysisId(id);

            /**
             * chc活动固定返回两轮, 将第一轮设置为所有
             */
            if (roundList.size() == 2) {
                roundList.get(0).setRoundId(-1);
            }

            analysisDto.setRoundList(roundList);
            builder.setData(analysisDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "获取活动详情", response = PicaResponse.class)
    @RequestMapping(value = "/psaActivityDetail", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<CHCAnalysisDto> getPSAActivityDetail(@RequestParam(required = false) Integer id) {
        PicaResponse.Builder<CHCAnalysisDto> builder = new PicaResponse.Builder<>();

        /**
         * 如果不传活动id进来，活动id就用1
         */
        id = (id == null ? 2 : id);

        try {
            CHCAnalysisDto analysisDto = analysisService.getPSAAnalysisDtoById(id);
            List<AnalysisRoundDto> roundList = analysisService.getRoundListByAnalysisId(id);

            analysisDto.setRoundList(roundList);
            builder.setData(analysisDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "获取某一轮的题目", response = PicaResponse.class)
    @RequestMapping(value = "/roundDetail/{roundId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<RoundExamTitleDto> getRoundDetail(@PathVariable("roundId") Integer roundId) {
        System.out.println("roundDetail: roundId" + roundId);

        PicaResponse.Builder<RoundExamTitleDto> builder = new PicaResponse.Builder<>();

        try {
            RoundExamTitleDto roundExamTitleDto = analysisService.getRoundExamTitleDtoById(roundId);
            List<ExamTitleDto> examTitleDtoList = analysisService.getExamTitleListByRoundId(roundId);

            roundExamTitleDto.setExamTitleList(examTitleDtoList);
            builder.setData(roundExamTitleDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "获取某一道题目的回复列表", response = PicaResponse.class)
    @RequestMapping(value = "/replyList/{examTitleId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<ExamTitleReplyDto> getReplyList(@PathVariable("examTitleId") Integer examTitleId,
                                                        @RequestHeader(required = false) String token) {
        PICAUser user = null;

        if (token != null) {
            user = CommonUtils.getUserByToken(redisClient, token);
        }

        PicaResponse.Builder<ExamTitleReplyDto> builder = new PicaResponse.Builder<>();

        try {
            AnalysisRoundExamTitle analysisRoundExamTitle = analysisService.getAnanlysisRoundExamTitleById(examTitleId);

            ExamTitleReplyDto examTitleReplyDto = new ExamTitleReplyDto();
            ExamTitleDto examTitleDto = analysisService.getExamTitleDtoById(examTitleId);
            List<ReplyDto> replyDtoList = analysisService.getReplyListDtoByExamTitleId(examTitleId, user !=  null ? user.getId() : 0);

            /**
             * TODO: 如果是PSA 删除时间显示
             */
            /*if (analysisRoundExamTitle.getAnalysisId().intValue() == 2 ) {
                for (ReplyDto replyDto : replyDtoList) {
                    replyDto.setReplayTime("");
                }
            }*/

            examTitleReplyDto.setAnalysisId(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDto.setRoundId(analysisRoundExamTitle.getRoundId());
            examTitleReplyDto.setExamTitle(examTitleDto);
            examTitleReplyDto.setReplyList(replyDtoList);

            AnalysisRound analysisRound = analysisService.getRoundInfoById(analysisRoundExamTitle.getRoundId());
            /**
             * 设置回复状态
             */
            if ((new Date()).getTime() > analysisRound.getEndTime().getTime()) {
                examTitleReplyDto.setReplyStatus(2);
            } else {
                examTitleReplyDto.setReplyStatus(0);

                if (user != null && user.getId() != 0) {
                    examTitleReplyDto.setReplyStatus(getReplyStatus(analysisRoundExamTitle.getAnalysisId(),
                            examTitleId, user.getId()));
                }
            }
            /**
             * 设置类型
             */
            CHCAnalysis analysis = analysisService.getAnalysisById(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDto.setType(analysis.getType().intValue());

            builder.setData(examTitleReplyDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "查看回复详情", response = PicaResponse.class)
    @RequestMapping(value = "/replyDetail/{replyId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<ExamTitleReplyDetailDto> getReplyDetail(@PathVariable("replyId") Integer replyId,
                                                                @RequestHeader(required = false) String token) {
        PICAUser user = null;

        if (token != null) {
            user = CommonUtils.getUserByToken(redisClient, token);
        }

        PicaResponse.Builder<ExamTitleReplyDetailDto> builder = new PicaResponse.Builder<>();

        try {
            ExamTitleReplyDetailDto examTitleReplyDetailDto = new ExamTitleReplyDetailDto();

            Reply reply =  analysisService.getReplyById(replyId);
            AnalysisRoundExamTitle analysisRoundExamTitle = analysisService.getAnanlysisRoundExamTitleById(reply.getAnalysisRoundExamTitleId());

            ExamTitleDto examTitleDto = analysisService.getExamTitleDtoById(reply.getAnalysisRoundExamTitleId());
            ReplyDto replyDto = analysisService.getReplyDtoByReply(reply, user != null ? user.getId() : 0);

            examTitleReplyDetailDto.setAnalysisId(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDetailDto.setRoundId(analysisRoundExamTitle.getRoundId());
            examTitleReplyDetailDto.setExamTitle(examTitleDto);
            examTitleReplyDetailDto.setReply(replyDto);

            AnalysisRound analysisRound = analysisService.getRoundInfoById(analysisRoundExamTitle.getRoundId());

            /**
             * 设置回复状态
             */
            if ((new Date()).getTime() > analysisRound.getEndTime().getTime()) {
                examTitleReplyDetailDto.setReplyStatus(2);
            }
            {
                examTitleReplyDetailDto.setReplyStatus(0);

                if (user != null && user.getId() != 0) {
                    examTitleReplyDetailDto.setReplyStatus(getReplyStatus(analysisRoundExamTitle.getAnalysisId(),
                            reply.getAnalysisRoundExamTitleId(), user.getId()));
                }
            }
            /**
             * 设置类型
             */
            CHCAnalysis analysis = analysisService.getAnalysisById(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDetailDto.setType(analysis.getType().intValue());

            builder.setData(examTitleReplyDetailDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "查看回复详情", response = PicaResponse.class)
    @RequestMapping(value = "/replyDetailByExamTitleId/{examTitleId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<ExamTitleReplyDetailDto> getReplyDetailByExamTitleId(@PathVariable("examTitleId") Integer examTitleId,
                                                                @RequestHeader(required = false) String token) {
        System.out.println("replyDetailByExamTitleId: examTitleId == " + examTitleId.toString() + ", token=" + token);
        PICAUser user = null;

        if (token != null) {
            user = CommonUtils.getUserByToken(redisClient, token);
        }

        PicaResponse.Builder<ExamTitleReplyDetailDto> builder = new PicaResponse.Builder<>();

        try {
            ExamTitleReplyDetailDto examTitleReplyDetailDto = new ExamTitleReplyDetailDto();

            Reply reply =  analysisService.getReplyByExamTitleId(examTitleId, user != null ? user.getId() : 0);
            AnalysisRoundExamTitle analysisRoundExamTitle = analysisService.getAnanlysisRoundExamTitleById(examTitleId);
            ExamTitleDto examTitleDto = analysisService.getExamTitleDtoById(examTitleId);

            ReplyDto replyDto = new ReplyDto();
            if (null != reply) {
                replyDto = analysisService.getReplyDtoByReply(reply, user != null ? user.getId() : 0);
            } else {
                replyDto.setContent("");
            }
            examTitleReplyDetailDto.setAnalysisId(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDetailDto.setRoundId(analysisRoundExamTitle.getRoundId());
            examTitleReplyDetailDto.setExamTitle(examTitleDto);
            examTitleReplyDetailDto.setReply(replyDto);

            builder.setData(examTitleReplyDetailDto);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return builder.build();
    }

    @ApiOperation(value = "点赞", response = PicaResponse.class)
    @RequestMapping(value = "/starReply/{replyId}/analysis/{analysisId}/round/{roundId}/examTitle/{examTitleId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse starReply(@PathVariable("analysisId") Integer analysisId, @PathVariable("roundId") Integer roundId,
                                  @PathVariable("examTitleId") Integer examTitleId, @PathVariable("replyId") Integer replyId,
                                  @RequestHeader(required = false) String token) {
        if (token == null) {
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_NO_TOKEN);
        }

        PICAUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            System.out.println("starrecord: user == null, token=" + token);
            return ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
        }

        Doctor doctor = doctorService.getDoctorById(user.getId());

        if (doctor == null) {
            System.out.println("starrecord: doctor == null, userid=" + user.getId().toString());
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INVALID_TOKEN);
        }

        /**
         * 未认证用户直接返回
         */
        if (!(doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_3) ||
                doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_6) ||
                doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_7) )) {
            return ReturnUtil.getPicaResponse(PicaResultCode.INTERFACE_FORBID_VISIT);
        }

        System.out.println("starrecord: replyid=" +  replyId.toString() + " token=" + token + " roundId=" + roundId + " examTitleId=" + examTitleId);

        if (0 != analysisService.insertStarRecord(analysisId, roundId, examTitleId, replyId, user.getId())) {
            /**
             * 已经点过赞
             */
            return ReturnUtil.getPicaResponse(PicaResultCode.DATA_ALREADY_EXISTED);
        }
        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }

    @ApiOperation(value = "取消点赞", response = PicaResponse.class)
    @RequestMapping(value = "/cancelStar/{replyId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse cancelStar( @PathVariable("replyId") Integer replyId,
                                    @RequestHeader(required = false) String token) {
        if (token == null) {
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_NO_TOKEN);
        }

        PICAUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            System.out.println("cancelStar: user == null, token=" + token);
            return ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
        }

        System.out.println("cancelStar: replyid=" +  replyId.toString() + " token=" + token);

        if (0 != analysisService.removeStarRecord(replyId, user.getId())) {
            return ReturnUtil.getPicaResponse(PicaResultCode.RESULE_DATA_NONE);
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }

    @ApiOperation(value = "获取某一道题目的下一道题", response = PicaResponse.class)
    @RequestMapping(value = "/nextExamTitle/{examTitleId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<ExamTitleReplyDto> nextReplyList(@PathVariable("examTitleId") Integer examTitleId,
                                                         @RequestHeader(required = false) String token) {

        PICAUser user = null;

        if (token != null) {
            user = CommonUtils.getUserByToken(redisClient, token);
        }

        PicaResponse.Builder<ExamTitleReplyDto> builder = new PicaResponse.Builder<>();

        try {
            AnalysisRoundExamTitle analysisRoundExamTitle = analysisService.getAnanlysisRoundExamTitleById(examTitleId);

            ExamTitleReplyDto examTitleReplyDto = new ExamTitleReplyDto();
            ExamTitleDto examTitleDto = analysisService.getNextExamTitleDtoById(analysisRoundExamTitle.getRoundId(), examTitleId);
            List<ReplyDto> replyDtoList = analysisService.getReplyListDtoByExamTitleId(examTitleDto.getExamTitleId(), user !=  null ? user.getId() : 0);

            examTitleReplyDto.setAnalysisId(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDto.setRoundId(analysisRoundExamTitle.getRoundId());
            examTitleReplyDto.setExamTitle(examTitleDto);
            examTitleReplyDto.setReplyList(replyDtoList);

            AnalysisRound analysisRound = analysisService.getRoundInfoById(analysisRoundExamTitle.getRoundId());
            /**
             * 设置回复状态
             */
            if ((new Date()).getTime() > analysisRound.getEndTime().getTime()) {
                examTitleReplyDto.setReplyStatus(2);
            } else {
                examTitleReplyDto.setReplyStatus(0);
                if (user != null && user.getId() != 0) {
                    examTitleReplyDto.setReplyStatus(getReplyStatus(analysisRoundExamTitle.getAnalysisId(),
                            examTitleId, user.getId()));
                }
            }
            /**
             * 设置类型
             */
            CHCAnalysis analysis = analysisService.getAnalysisById(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDto.setType(analysis.getType().intValue());

            builder.setData(examTitleReplyDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "获取某一道题目的下一道题", response = PicaResponse.class)
    @RequestMapping(value = "/nextReply/{replyId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<ExamTitleReplyDto> nextReplyDetail(@PathVariable("replyId") Integer replyId,
                                                           @RequestHeader(required = false) String token) {

        PICAUser user = null;

        if (token != null) {
            user = CommonUtils.getUserByToken(redisClient, token);
        }

        PicaResponse.Builder<ExamTitleReplyDetailDto> builder = new PicaResponse.Builder<>();

        try {
            ExamTitleReplyDetailDto examTitleReplyDetailDto = new ExamTitleReplyDetailDto();

            Reply reply =  analysisService.getNextReplyById(replyId);
            AnalysisRoundExamTitle analysisRoundExamTitle = analysisService.getAnanlysisRoundExamTitleById(reply.getAnalysisRoundExamTitleId());

            ExamTitleDto examTitleDto = analysisService.getExamTitleDtoById(reply.getAnalysisRoundExamTitleId());
            ReplyDto replyDto = analysisService.getReplyDtoByReply(reply, user != null ? user.getId() : 0);

            examTitleReplyDetailDto.setAnalysisId(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDetailDto.setRoundId(analysisRoundExamTitle.getRoundId());
            examTitleReplyDetailDto.setExamTitle(examTitleDto);
            examTitleReplyDetailDto.setReply(replyDto);

            AnalysisRound analysisRound = analysisService.getRoundInfoById(analysisRoundExamTitle.getRoundId());
            /**
             * 设置回复状态
             */
            if ((new Date()).getTime() > analysisRound.getEndTime().getTime()) {
                examTitleReplyDetailDto.setReplyStatus(2);
            } else {
                examTitleReplyDetailDto.setReplyStatus(0);

                if (user != null && user.getId() != 0) {
                    examTitleReplyDetailDto.setReplyStatus(getReplyStatus(analysisRoundExamTitle.getAnalysisId(),
                            reply.getAnalysisRoundExamTitleId(), user.getId()));
                }
            }
            /**
             * 设置类型
             */
            CHCAnalysis analysis = analysisService.getAnalysisById(analysisRoundExamTitle.getAnalysisId());
            examTitleReplyDetailDto.setType(analysis.getType().intValue());

            builder.setData(examTitleReplyDetailDto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }

    @ApiOperation(value = "回复", response = PicaResponse.class)
    @RequestMapping(value = "/reply/{examTitleId}", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse reply( @PathVariable("examTitleId") Integer examTitleId,
                               @RequestBody String content,
                               @RequestHeader String sysCode,
                               @RequestHeader String token) {
        if (token == null) {
            PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_NO_TOKEN);
            picaResponse.setData("");
            return picaResponse;
        }

        PICAUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            System.out.println("reply: user == null, token=" + token);
            PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
            picaResponse.setData("");
            return picaResponse;
        }

        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            content = jsonObject.get("content").toString();
        } catch (Exception e) {
            System.out.println("parse error: " + content);
        }

        /**
         * 如果判断检测的数据中有垃圾 直接返回
         */
        PicaResponse response = antiSpamService.processString(user != null ? user.getId() : 0, sysCode, content);
        if (!response.getCode().equals(PicaResultCode.SUCCESS.code())) {
            response.setData("");
            return response;
        }

        /**
         * 插入数据库
         */
        try {
            analysisService.insertReply(examTitleId, content, user.getId());
        } catch (Exception e) {
            PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.INTERFACE_INVOKE_EXCEPTION);
            picaResponse.setData("");
            return picaResponse;
        }

        PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
        picaResponse.setMessage("发布成功");
        return picaResponse;
    }

    Integer getReplyStatus(Integer analysisId, Integer examTitleId,  Integer userId) {
        Doctor doctor = doctorService.getDoctorById(userId);

        if (doctor != null) {
            CHCAnalysis analysis =  analysisService.getAnalysisById(analysisId);
            if (analysis.getType() == 1) {
                /**
                 * CHC 获取考试前两百名
                 */
                if (rankingListService.isRankingInTop200(doctor.getId())) {
                    return analysisService.getReplyStatus(examTitleId, userId);
                }

            } else if (analysis.getType() == 2) {
                /**
                 * 如果为认证 不可见
                 */
                if (!(doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_3) ||
                        doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_6) ||
                        doctor.getStatus().equals(CommonConstants.DOCTOR_STATUS_7) )) {
                    return 0;
                }
                /**
                 * PSA 职务职称主任/副主任 院长/副院长 科长/副科长 管理人数100以上
                 */
                if (doctorService.isAuth(doctor.getId())) {
                    return analysisService.getReplyStatus(examTitleId, userId);
                }
            }
        }

        return 0;
    }

    @ApiOperation(value = "获取某一轮的题目V2", response = PicaResponse.class)
    @RequestMapping(value = "/roundDetail/v2/{roundId}", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<RoundExamTitleV2Dto> getRoundDetailV2(@PathVariable(value = "roundId") Integer roundId) {
        System.out.println("roundDetail: roundId" + roundId);
        PicaResponse.Builder<RoundExamTitleV2Dto> builder = new PicaResponse.Builder<>();

        try {
            RoundExamTitleV2Dto roundExamTitleV2Dto = new RoundExamTitleV2Dto();
            if (roundId > 0) {
                /**
                 * 有rounfid传入时设置roundList为空
                 */
                roundExamTitleV2Dto.setRoundList(new ArrayList<>());
            } else {
                List<AnalysisRoundDto> roundDtoList = analysisService.getCHCHistoryRound();

                /**
                 * 获取list中第一个的roundId
                 */
                roundId = roundDtoList.get(0).getRoundId();

                roundExamTitleV2Dto.setRoundList(roundDtoList);
            }

            RoundExamTitleDto roundExamTitleDto = analysisService.getRoundExamTitleDtoById(roundId);

            /**
             * 转换格式
             */
            roundExamTitleV2Dto.setAnalysisId(roundExamTitleDto.getAnalysisId());
            roundExamTitleV2Dto.setRoundId(roundExamTitleDto.getRoundId());
            roundExamTitleV2Dto.setStartTime(roundExamTitleV2Dto.getStartTime());
            roundExamTitleV2Dto.setEndTime(roundExamTitleV2Dto.getEndTime());
            roundExamTitleV2Dto.setTotalCount(roundExamTitleDto.getTotalCount());
            roundExamTitleV2Dto.setPublished(roundExamTitleDto.getPublished());

            List<ExamTitleDto> examTitleDtoList = analysisService.getExamTitleListByRoundId(roundId);
            roundExamTitleV2Dto.setExamTitleList(examTitleDtoList);
            builder.setData(roundExamTitleV2Dto);
        } catch (Exception e) {
            e.printStackTrace();
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_INNER_ERROR);
        }

        return builder.build();
    }
}
