package com.pica.cloud.online.exam.analysis.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.online.exam.analysis.server.client.IOnlineExamServiceClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wuminghao
 * @date 2018/9/30 9:58
 */
@RestController
@RequestMapping("/onlineexam")
@Api(value = "服务调用", description = "测试")
public class TestController {
    @Autowired
    private IOnlineExamServiceClient onlineExamServiceClient;

    @ApiOperation(value = "获取考试状态", response = PicaResponse.class)
    @RequestMapping(value = "/getExamStatus", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public String getExamStatus(@RequestHeader String token) {
        return onlineExamServiceClient.getExamStatus(1,1, "27", token);
    }
}
