package com.pica.cloud.online.exam.analysis.server.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author wuminghao
 * @date 2018/9/1 10:54
 */
public class DateUtils {
    private static final long ONE_MINITE = 60;
    private static final long ONE_HOUR = 3600;
    private static final long ONE_DAY = 86400;

    public static Calendar calendar = Calendar.getInstance();

    public static String fromNow(Date date) {
        calendar.setTime(date);

        long time = date.getTime() / 1000;
        long now = (new Date()).getTime() / 1000;
        long interval = now - time;

        if (interval <= ONE_MINITE) {
          return interval + "秒前";
        } else if (interval <= ONE_HOUR) {
            return interval / ONE_MINITE + "分钟前";
        } else if (interval <= ONE_DAY) {
            return interval / ONE_HOUR + "小时前";
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }
}
