package com.pica.cloud.online.exam.analysis.server.configuration;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import javax.sql.DataSource;

/**
 * @author wuminghao
 * @date 2018/8/23 8:46
 */
@Configuration
public class DataSourceConfig {
    /**
     * 如果取不到  就用默认值
     */
    @Value("${spring.datasource.url}")
    private String dataSourceUrl;

    @Value("${spring.datasource.username}")
    private String user;

    @Value("${spring.datasource.password}")
    private String password;

    @Value("${spring.datasource.hikari.pool-name}")
    private String poolName;

    @Value("${spring.datasource.hikari.connection-test-query}")
    private String testQuery;

    @Value("${spring.datasource.tomcat.init-s-q-l}")
    private String initQuery;

    @Value("${spring.hikari.cachePrepStmts}")
    private String cachePrepStmts             ;

    @Value("${spring.hikari.prepStmtCacheSize}")
    private String prepStmtCacheSize          ;

    @Value("${spring.hikari.prepStmtCacheSqlLimit}")
    private String prepStmtCacheSqlLimit      ;

    @Value("${spring.hikari.useServerPrepStmts}")
    private String useServerPrepStmts         ;

    @Value("${spring.hikari.useLocalSessionState}")
    private String useLocalSessionState       ;

    @Value("${spring.hikari.useLocalTransactionState}")
    private String useLocalTransactionState   ;

    @Value("${spring.hikari.rewriteBatchedStatements}")
    private String rewriteBatchedStatements   ;

    @Value("${spring.hikari.cacheResultSetMetadata}")
    private String cacheResultSetMetadata     ;

    @Value("${spring.hikari.cacheServerConfiguration}")
    private String cacheServerConfiguration   ;

    @Value("${spring.hikari.elideSetAutoCommits}")
    private String elideSetAutoCommits        ;

    @Value("${spring.hikari.maintainTimeStats}")
    private String maintainTimeStats          ;
    private static final String X_TOTAL_COUNT = "20";

    @Bean
    public DataSource primaryDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(dataSourceUrl); //数据源
        config.setUsername(user); //用户名
        config.setPassword(password); //密码
        config.setConnectionTestQuery(testQuery);
        config.setPoolName(poolName);
        config.setConnectionInitSql(initQuery);
        config.addDataSourceProperty("cachePrepStmts", cachePrepStmts); //是否自定义配置，为true时下面两个参数才生效
        config.addDataSourceProperty("prepStmtCacheSize", prepStmtCacheSize); //连接池大小默认25，官方推荐250-500
        config.addDataSourceProperty("prepStmtCacheSqlLimit", prepStmtCacheSqlLimit); //单条语句最大长度默认256，官方推荐2048
        config.addDataSourceProperty("useServerPrepStmts", useServerPrepStmts); //新版本MySQL支持服务器端准备，开启能够得到显著性能提升
        config.addDataSourceProperty("useLocalSessionState", useLocalSessionState);
        config.addDataSourceProperty("useLocalTransactionState", useLocalTransactionState);
        config.addDataSourceProperty("rewriteBatchedStatements", rewriteBatchedStatements);
        config.addDataSourceProperty("cacheResultSetMetadata", cacheResultSetMetadata);
        config.addDataSourceProperty("cacheServerConfiguration", cacheServerConfiguration);
        config.addDataSourceProperty("elideSetAutoCommits", elideSetAutoCommits);
        config.addDataSourceProperty("maintainTimeStats", maintainTimeStats);
        HikariDataSource ds = new HikariDataSource(config);
        return ds;
    }

    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.addExposedHeader(X_TOTAL_COUNT);
        return corsConfiguration;
    }

    /**
     * 跨域过滤器
     *
     * @return
     */
    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", buildConfig()); // 4
        return new CorsFilter(source);
    }
}
