package com.pica.cloud.online.exam.analysis.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.RedisClient;
import com.pica.cloud.foundation.utils.annotation.LoginPermission;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.online.exam.analysis.common.CommonUtils;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author wuminghao
 * @date 2018/9/3 9:35
 */
@RestController
@RequestMapping("/antispam")
@Api(value = "内容甄别解析", description = "检测文本、图片内容")
public class AntiSpamController {
    @Autowired
    private RedisClient redisClient;

    @Autowired
    AntiSpamService antiSpamService;

    @LoginPermission
    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processText(@RequestBody String content,
                                @RequestHeader String sysCode,
                                @RequestHeader String token) {
        PicaUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            return ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
        }

        StringBuilder sbContent = new StringBuilder();
        /**
         * type:0 不检测广告 其他: 检测广告, 默认不检测
         */
        Integer type = 0;
        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            sbContent.append(jsonObject.get("content").toString());
            type = (jsonObject.get("type") != null ? Integer.parseInt(jsonObject.get("type").toString()) : 0);
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }

        return antiSpamService.processString(
                user.getId(),
                sysCode,
                sbContent.toString(),
                type != 0
        );
   }

    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text/v1", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processTextV1(@RequestBody String content,
                                    @RequestHeader String sysCode,
                                    @RequestHeader String token) {
        return processText(content, sysCode, token);
    }

    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text/v2", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processTextV2(@RequestBody String content,
                                      @RequestHeader String sysCode,
                                      @RequestHeader String token) {
        PicaUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            return ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
        }

        StringBuilder sbContent = new StringBuilder();
        /**
         * type:0 不检测广告 其他: 检测广告, 默认不检测
         */
        Integer type = 0;
        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            sbContent.append(jsonObject.get("content").toString());
            type = (jsonObject.get("type") != null ? Integer.parseInt(jsonObject.get("type").toString()) : 0);
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }

        return antiSpamService.processStringV2(
                user.getId(),
                sysCode,
                sbContent.toString(),
                type != 0
        );
    }

    @ApiOperation(value = "图片检测", response = PicaResponse.class)
    @RequestMapping(value = "/image", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processImage(@RequestBody String content,
                                @RequestHeader String sysCode,
                                @RequestHeader String token) {
        if (token == null) {
            return ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_NO_TOKEN);
        }

        PicaUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            return ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
        }

        StringBuilder sbContent = new StringBuilder();
        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            sbContent.append(jsonObject.get("content").toString());
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }

        if (!antiSpamService.processImageContent(user.getId(), sysCode, sbContent.toString())) {
            return ReturnUtil.getPicaResponse("400002", "图片包含违禁内容，请修改后重新输入", "");
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }
}
