package com.pica.cloud.online.exam.analysis.server.service.impl;

import com.pica.cloud.online.exam.analysis.common.dto.DoctorDto;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.online.exam.analysis.server.entity.Doctor;
import com.pica.cloud.online.exam.analysis.server.mapper.DoctorMapper;
import com.pica.cloud.online.exam.analysis.server.service.DoctorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author wuminghao
 * @date 2018/8/18 11:02
 */
@Service
public class DoctorServiceImpl implements DoctorService {
    @Autowired
    DoctorMapper doctorMapper;

    @Autowired
    private PropertiesConfiguration properties;

    @Override
    public Doctor getDoctorById(Integer doctorId) {
        return doctorMapper.selectByPrimaryKey(doctorId);
    }

    @Override
    public DoctorDto getDoctorDtoById(Integer doctorId) {
        Doctor doctor =  doctorMapper.selectByPrimaryKey(doctorId);
        DoctorDto doctorDto = new DoctorDto();

        doctorDto.setId(doctor.getId());
        doctorDto.setName(doctor.getName());
        doctorDto.setHospital(doctor.getHospital());
        doctorDto.setTitle(doctor.getTitle());
        doctorDto.setAvatarImageUrl(doctor.getAvatarImageUrl() != null
                ? properties.getFileUrl() + doctor.getAvatarImageUrl().trim()
                : properties.getFileUrl() + "/File/doctor_default.png");

        return doctorDto;
    }

    @Override
    public boolean isAuth(Integer doctorId) {
        return doctorMapper.selectAuthByDoctorId(doctorId) > 0 ||
                doctorMapper.selectPatientCountByDoctorId(doctorId) >= 100;
    }
}
