package com.pica.cloud.online.exam.analysis.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.RedisClient;
import com.pica.cloud.foundation.utils.entity.PICAUser;
import com.pica.cloud.online.exam.analysis.common.CommonUtils;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author wuminghao
 * @date 2018/9/3 9:35
 */
@RestController
@RequestMapping("/antispam")
@Api(value = "内容甄别解析", description = "检测文本、图片内容")
public class AntiSpamController {
    @Autowired
    private RedisClient redisClient;

    @Autowired
    AntiSpamService antiSpamService;

    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse process(@RequestBody String content,
                                @RequestHeader String sysCode,
                                @RequestHeader String token) {
        if (token == null) {
            PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.SYSTEM_NO_TOKEN);
            picaResponse.setData("");
            return picaResponse;
        }

        PICAUser user = CommonUtils.getUserByToken(redisClient, token);

        if (user == null || user.getId().intValue() == 0) {
            PicaResponse picaResponse = ReturnUtil.getPicaResponse(PicaResultCode.LOGIN_FAILE);
            picaResponse.setData("");
            return picaResponse;
        }

        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            content = jsonObject.get("content").toString();
        } catch (Exception e) {
            System.out.println("parse error: " + content);
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }
        return antiSpamService.processString(user != null ? user.getId() : 0, sysCode, content);
    }
}
