package com.pica.cloud.online.exam.analysis.server.utils;

import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.*;

/**
 * @author wuminghao
 * @date 2018/8/23 15:44
 */
public class HttpClient4Utils {
    private static Logger logger = LoggerFactory.getLogger(HttpClient4Utils.class);
    /**
     * 实例化HttpClient
     * @param maxTotal
     * @param maxPerRoute
     * @param socketTimeout
     * @param connectTimeout
     * @param connectionRequestTimeout
     * @return
     */
    public static HttpClient createHttpClient(int maxTotal, int maxPerRoute, int socketTimeout, int connectTimeout,
                                              int connectionRequestTimeout) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout)
                .setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectionRequestTimeout).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(cm)
                .setDefaultRequestConfig(defaultRequestConfig).build();
        return httpClient;
    }

    /**
     * 发送post请求
     * @param httpClient
     * @param url 请求地址
     * @param params 请求参数
     * @param encoding 编码
     * @return
     */
    public static String sendPost(HttpClient httpClient, String url, Map<String, String> params, Charset encoding) {
        String resp = "";
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            List<NameValuePair> formParams = new ArrayList<NameValuePair>();
            Iterator<Map.Entry<String, String>> itr = params.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, String> entry = itr.next();
                formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postEntity = new UrlEncodedFormEntity(formParams, encoding);
            httpPost.setEntity(postEntity);
        }
//        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse) httpClient.execute(httpPost);
            resp = EntityUtils.toString(response.getEntity(), encoding);
        } catch (Exception e) {
            logger.error("sendPost", e);
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    logger.error("sendPost", e);
                }
            }
        }
        return resp;
    }

    public static void main(String[] s) {
        HttpClient httpClient = HttpClient4Utils.createHttpClient(200, 200, 2000, 2000, 2000);
        Map<String, String> params = new HashMap<String, String>();

        /**
         * 1. 设置公共参数
         */
        params.put("secretId", "f437763dcf0a4096948b0cfbaebd668b");


        params.put("businessId", "7065ac9c9cf4472fbf44fe3f90a03624");

        params.put("version", "v1");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce", String.valueOf(new Random().nextInt()));

        /**
         * 2. 设置私有参数
         */
//        params.put("dataId", "ebfcad1c-pica-490c-b4de-e784c2691768");
        params.put("name", "韦少峰");
        params.put("cardNo", "440624198310214613");

        /**
         * 3. 生成签名信息
         */
        try {
            String signature = SignatureUtils.genSignature("6cc930e9e481fce8e5d3da30dddf74c4", params);
            params.put("signature", signature);
        } catch (UnsupportedEncodingException e) {
            logger.error("processString", e);
        }

        /**
         * 4. 发送HTTP请求
         */
        System.out.println(sendPost(httpClient, "https://verify.dun.163.com/v1/idcard/check", params, Consts.UTF_8));
    }
}
