package com.pica.cloud.online.exam.analysis.server.service.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import com.pica.cloud.online.exam.analysis.server.utils.HttpClient4Utils;
import com.pica.cloud.online.exam.analysis.server.utils.SignatureUtils;
import org.apache.http.Consts;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * @author wuminghao
 * @date 2018/8/27 14:38
 */
@Service
public class AntiSpamServiceImpl implements AntiSpamService {
    @Autowired
    private PropertiesConfiguration properties;

    private static HttpClient httpClient = HttpClient4Utils.createHttpClient(100, 20, 2000, 2000, 2000);

    @Override
    public PicaResponse processString(String content) {
        Map<String, String> params = new HashMap<String, String>();

        /**
         * 1. 设置公共参数
         */
        params.put("secretId", properties.getNeteaseAntispamSecretId());
        params.put("businessId", properties.getNeteaseAntispamTextBusinessId());
        params.put("version", "v3.1");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce", String.valueOf(new Random().nextInt()));

        /**
         * 2. 设置私有参数
         */
        params.put("content", content);

        /**
         * 3. 生成签名信息
         */
        try {
            String signature = SignatureUtils.genSignature(properties.getNeteaseAntispamSecretKey(), params);
            params.put("signature", signature);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        /**
         * 4. 发送HTTP请求
         */
        String response = HttpClient4Utils.sendPost(httpClient, properties.getNeteaseAntispamTextApiUrl(), params, Consts.UTF_8);

        /**
         * 5. 解析返回值
         */
        JsonObject jObject = new JsonParser().parse(response).getAsJsonObject();
        int code = jObject.get("code").getAsInt();
        String msg = jObject.get("msg").getAsString();
        if (code == 200) {

        } else {
            return ReturnUtil.getPicaResponse(PicaResultCode.DATA_IS_WRONG);
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.DATA_IS_WRONG);
    }
}
