package com.pica.cloud.online.exam.analysis.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.annotation.LoginPermission;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.configuration.SpringContextAware;
import com.pica.cloud.online.exam.analysis.server.constants.RedisKey;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author wuminghao
 * @date 2018/9/3 9:35
 */
@RestController
@RequestMapping("/antispam")
public class AntiSpamController extends BaseController {
    @Autowired
    private ICacheClient redisClient;

    @Autowired
    private SpringContextAware springContextAware;

    @Autowired
    AntiSpamService antiSpamService;

    @LoginPermission
    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processText(@RequestBody String content,
                                @RequestHeader String sysCode,
                                @RequestHeader String token) {

        if (!"prod".equals(springContextAware.getActiveProfile())) {
            String enableAntispam = redisClient.get(RedisKey.ENABLE_ANTI_SPAM);
            if ("0".equals(enableAntispam)) {
                return PicaResponse.toResponse("");
            }
        }

        PicaUser user = fetchPicaUser();
        Pair<String, Integer> params;
        try {
            params = parseContentAndType(content);
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }
        return antiSpamService.processString(user.getId(), sysCode, params.getLeft(), params.getRight() != 0);
   }

    @LoginPermission
    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text/v1", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processTextV1(@RequestBody String content,
                                    @RequestHeader String sysCode,
                                    @RequestHeader String token) {
        if (!"prod".equals(springContextAware.getActiveProfile())) {
            String enableAntispam = redisClient.get(RedisKey.ENABLE_ANTI_SPAM);
            if ("0".equals(enableAntispam)) {
                return PicaResponse.toResponse("");
            }
        }
        return processText(content, sysCode, token);
    }

    @LoginPermission
    @ApiOperation(value = "内容检测", response = PicaResponse.class)
    @RequestMapping(value = "/text/v2", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processTextV2(@RequestBody String content,
                                      @RequestHeader String sysCode,
                                      @RequestHeader String token) {
        if (!"prod".equals(springContextAware.getActiveProfile())) {
            String enableAntispam = redisClient.get(RedisKey.ENABLE_ANTI_SPAM);
            if ("0".equals(enableAntispam)) {
                return PicaResponse.toResponse("");
            }
        }
        PicaUser user = fetchPicaUser();
        Pair<String, Integer> params;
        try {
             params = parseContentAndType(content);
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }

        return antiSpamService.processStringV2(user.getId(), sysCode, params.getLeft(), params.getRight() != 0);
    }

    @LoginPermission
    @ApiOperation(value = "图片检测", response = PicaResponse.class)
    @RequestMapping(value = "/image", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public PicaResponse processImage(@RequestBody String content,
                                @RequestHeader String sysCode,
                                @RequestHeader String token) {
        if (!"prod".equals(springContextAware.getActiveProfile())) {
            String enableAntispam = redisClient.get(RedisKey.ENABLE_ANTI_SPAM);
            if ("0".equals(enableAntispam)) {
                return PicaResponse.toResponse("");
            }
        }

        PicaUser user = fetchPicaUser();
        StringBuilder sbContent = new StringBuilder();
        try {
            JSONObject jsonObject = JSONObject.parseObject(content);
            sbContent.append(jsonObject.get("content").toString());
        } catch (Exception e) {
            return ReturnUtil.getPicaResponse(PicaResultCode.PARAM_IS_INVALID);
        }

        if (!antiSpamService.processImageContent(user.getId(), sysCode, sbContent.toString())) {
            return ReturnUtil.getPicaResponse("400002", "图片包含违禁内容，请修改后重新输入", "");
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }

    public Pair<String, Integer> parseContentAndType(String content) {
        JSONObject jsonObject = JSONObject.parseObject(content);
        return Pair.of(jsonObject.get("content").toString(),
                jsonObject.get("type") != null ? Integer.parseInt(jsonObject.get("type").toString()) : 0
        );
    }
}
