package com.pica.cloud.online.exam.analysis.client.service;

import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author wuminghao
 * @date 2018/12/10 17:03
 */
@FeignClient(value="10902-PICA-CLOUD-ANALYSIS")
public interface AnalysisFeignService {
    @RequestMapping(value = "/analysis/antispam/text/v1", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    PicaResponse processTextV1(@RequestBody String content,
                             @RequestHeader(value = "sysCode") String sysCode,
                             @RequestHeader(value = "token") String token);

    @RequestMapping(value = "/analysis/antispam/text/v2", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    PicaResponse processTextV2(@RequestBody String content,
                               @RequestHeader(value = "sysCode") String sysCode,
                               @RequestHeader(value = "token") String token);
}
