package com.pica.cloud.online.exam.analysis.server.service;

import com.pica.cloud.online.exam.analysis.common.dto.DoctorDto;
import com.pica.cloud.online.exam.analysis.server.entity.Doctor;

/**
 * @author wuminghao
 * @date 2018/8/18 11:02
 */
public interface DoctorService {
    /**
     * 根据医生的id获取医生的信息
     * @param doctorId
     * @return
     */
    Doctor getDoctorById(Integer doctorId);

    /**
     * 根据医生id获取医生dtp
     * @return
     */
    DoctorDto getDoctorDtoById(Integer doctorId);

    /**
     * 根据医生的id获取医生的权限
     * @param doctorId
     * @return
     */
    boolean isAuth(Integer doctorId);
}
