package com.pica.cloud.online.exam.analysis.server.service;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.online.exam.analysis.common.dto.*;
import com.pica.cloud.online.exam.analysis.server.entity.AnalysisRound;
import com.pica.cloud.online.exam.analysis.server.entity.AnalysisRoundExamTitle;
import com.pica.cloud.online.exam.analysis.server.entity.CHCAnalysis;
import com.pica.cloud.online.exam.analysis.server.entity.Reply;
import io.swagger.models.auth.In;
import org.omg.CORBA.INTERNAL;

import java.util.List;
import java.util.Optional;

/**
 * @author wuminghao
 * @date 2018/8/17 9:40
 */
public interface CHCAnalysisService {

    /**
     * 获取CHC活动详情
     * @param analysisId 活动id
     * @param user
     * @return
     */
    CHCAnalysisDto getCHCActivityDetail(Integer analysisId, PicaUser user);

    /**
     * 获取PSA活动详情
     * @param analysisId 活动id
     * @return
     */
    CHCAnalysisDto getPSAActivityDetail(Integer analysisId);

    /**
     * 获取轮详情
     * @param roundId 轮id
     * @return
     */
    RoundExamTitleDto getRoundDetail(Integer roundId);

    /**
     * 获取轮详情V2
     * @param roundId
     * @return
     */
    RoundExamTitleV2Dto getRoundDetailV2(Integer roundId);

    /**
     * 获取题目的回复列表
     * @param examTitleId
     * @param user
     * @return
     */
    ExamTitleReplyDto getReplyListByExamTitleId(Integer examTitleId, PicaUser user);

    /**
     * 获取下一题的回复列表
     * @param examTitleId
     * @param user
     * @return
     */
    ExamTitleReplyDto getNextReplyListByExamTitleId(Integer examTitleId, PicaUser user);

    /**
     * 获取回复的详情
     * @param replyId 回复id
     * @param user 用户
     * @return
     */
    ExamTitleReplyDetailDto getReplyDetailByReplyId(Integer replyId, PicaUser user);

    /**
     * 获取下一回复的详情
     * @param replyId
     * @param user
     * @return
     */
    ExamTitleReplyDetailDto getNextReplyDetailByReplyId(Integer replyId, PicaUser user);

    /**
     * 获取回复的详情
     * @param examTitleId 题目id
     * @param user 用户
     * @return
     */
    ExamTitleReplyDetailDto getReplyDetailByExamTitleId(Integer examTitleId, PicaUser user);

    /**
     * 点赞
     * @param user 用户
     * @param analysisId 活动id
     * @param roundId 轮id
     * @param examTitleId 题目id
     * @param replyId 回复id
     * @return
     */
    PicaResponse starReply(PicaUser user, Integer analysisId, Integer roundId, Integer examTitleId, Integer replyId);

    /**
     * 解析/回复某一个题目
     * @param user 用户
     * @param sysCode
     * @param examTitleId 题目
     * @param content 内容
     * @param isAdFilterOpen 广告检测
     * @return
     */
    PicaResponse reply(PicaUser user, String sysCode, Integer examTitleId, String content, Boolean isAdFilterOpen);

    /**
     * 获取我的赞
     * @param user 用户
     * @param roundId 某轮的id
     * @return
     */
    MyStarDto myStar(PicaUser user, Optional<Integer> roundId);

    /**
     * 取消点赞
     * @param replyId 活动id
     * @param user 用户
     * @return
     */
    Integer removeStarRecord(Integer replyId, PicaUser user);
}
