package com.pica.cloud.online.exam.analysis.server.configuration;

import com.pica.cloud.foundation.redis.CacheMigrateClient;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class BeanConfiguration {
    @Autowired
    private SpringContextAware springContextAware;

    @Value("${spring.redis.config}")
    private String configStr;

    @Bean
    @ConditionalOnMissingBean
    public ICacheClient cacheClient() {
        return new CacheMigrateClient(springContextAware.getActiveProfile());

    }
}
