package com.pica.cloud.online.exam.analysis.server.service.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import com.pica.cloud.online.exam.analysis.server.utils.HttpClient4Utils;
import com.pica.cloud.online.exam.analysis.server.utils.SignatureUtils;
import org.apache.http.Consts;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * @author wuminghao
 * @date 2018/8/27 14:38
 */
@Service
public class AntiSpamServiceImpl implements AntiSpamService {
    @Autowired
    private PropertiesConfiguration properties;

    private static HttpClient httpClient = HttpClient4Utils.createHttpClient(100, 20, 2000, 2000, 2000);

    @Override
    public PicaResponse processString(String content) {
        Map<String, String> params = new HashMap<String, String>();

        /**
         * 1. 设置公共参数
         */
        params.put("secretId", properties.getNeteaseAntispamSecretId());
        params.put("businessId", properties.getNeteaseAntispamTextBusinessId());
        params.put("version", "v3.1");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce", String.valueOf(new Random().nextInt()));

        /**
         * 2. 设置私有参数
         */
        params.put("dataId", "ebfcad1c-pica-490c-b4de-e784c2691768");
        params.put("content", content);

        /**
         * 3. 生成签名信息
         */
        try {
            String signature = SignatureUtils.genSignature(properties.getNeteaseAntispamSecretKey(), params);
            params.put("signature", signature);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        /**
         * 4. 发送HTTP请求
         */
        String response = HttpClient4Utils.sendPost(httpClient, properties.getNeteaseAntispamTextApiUrl(), params, Consts.UTF_8);

        System.out.println("content:" +  content + " response=" + response);

        /**
         * 5. 解析返回值
         */
        JsonObject jObject = new JsonParser().parse(response).getAsJsonObject();
        int code = jObject.get("code").getAsInt();
        String msg = jObject.get("msg").getAsString();
        if (code == 200) {
            JsonObject resultObject = jObject.getAsJsonObject("result");
            int action = resultObject.get("action").getAsInt();

            /**
             * label: 100 色情
             * label: 200 广告
             * label: 400 违禁
             * label: 500 涉政
             * label: 600 谩骂
             * label: 700 灌水
             */
            JsonArray labelArray = resultObject.getAsJsonArray("labels");

            /**
             * action: 0 通过
             * action: 1 嫌疑
             * action: 2 不通过
             */
            if (action == 0) {

            } else {
                /**
                 * TODO: 可以进一步处理 显示信息被过滤原因
                 */
                for (JsonElement labelElement : labelArray) {
                    JsonObject lObject = labelElement.getAsJsonObject();
                    int label = lObject.get("label").getAsInt();
                    int level = lObject.get("level").getAsInt();
                    JsonObject detailsObject=lObject.getAsJsonObject("details");
                    JsonArray hintArray=detailsObject.getAsJsonArray("hint");

                    if (label == 100) msg = "输入内容包含色情词汇，请修改后重新输入";
                    else if (label == 200) msg = "输入内容包含广告词汇，请修改后重新输入";
                    else if (label == 400) msg = "输入内容包含违禁词汇，请修改后重新输入";
                    else if (label == 500) msg = "输入内容包含涉政词汇，请修改后重新输入";
                    else if (label == 600) msg = "输入内容包含谩骂词汇，请修改后重新输入";
                    else if (label == 700) msg = "输入内容包含灌水词汇，请修改后重新输入";

                    return ReturnUtil.getPicaResponse("400002", msg);
                }

            }

        } else {
            return ReturnUtil.getPicaResponse(jObject.get("code").getAsString(), msg, "");
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS, "");
    }
}
