package com.pica.cloud.online.exam.analysis.server.utils;

import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * @author wuminghao
 * @date 2020/6/28 15:35
 */
@Component
public class LoginUtil {
    public static final Logger logger =  LoggerFactory.getLogger(LoginUtil.class);

    @Autowired
    private ICacheClient cacheClient;

    public PicaUser getCurrentUser() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.currentRequestAttributes();
        String token = servletRequestAttributes.getRequest().getHeader("token");

        if (StringUtils.isEmpty(token)) {
            return null;
        } else {
            return cacheClient.getToken(token, PicaUser.class);
        }
    }

    public PicaUser getCurrentUserByToken(String token) {
        if (StringUtils.isEmpty(token)) {
            return null;
        } else {
            return cacheClient.getToken(token, PicaUser.class);
        }
    }
}
