package com.pica.cloud.online.exam.analysis.server.service.impl;

import com.pica.cloud.online.exam.analysis.server.entity.Doctor;
import com.pica.cloud.online.exam.analysis.server.mapper.DoctorMapper;
import com.pica.cloud.online.exam.analysis.server.service.DoctorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author wuminghao
 * @date 2018/8/18 11:02
 */
@Service
public class DoctorServiceImpl implements DoctorService {
    @Autowired
    DoctorMapper doctorMapper;

    @Override
    public Doctor getDoctorById(Integer doctorId) {
        return doctorMapper.selectByPrimaryKey(doctorId);
    }

    @Override
    public boolean isAuth(Integer doctorId) {
        return doctorMapper.selectAuthByDoctorId(doctorId) > 0 ||
                doctorMapper.selectPatientCountByDoctorId(doctorId) >= 100;
    }
}
