package com.pica.cloud.online.exam.analysis.server.service.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.online.exam.analysis.common.util.ReturnUtil;
import com.pica.cloud.online.exam.analysis.server.configuration.PropertiesConfiguration;
import com.pica.cloud.online.exam.analysis.server.entity.AntiSpamRecord;
import com.pica.cloud.online.exam.analysis.server.mapper.AntiSpamRecordMapper;
import com.pica.cloud.online.exam.analysis.server.service.AntiSpamService;
import com.pica.cloud.online.exam.analysis.server.utils.HttpClient4Utils;
import com.pica.cloud.online.exam.analysis.server.utils.SignatureUtils;
import org.apache.http.Consts;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.regex.Pattern;

/**
 * @author wuminghao
 * @date 2018/8/27 14:38
 */
@Service
public class AntiSpamServiceImpl implements AntiSpamService {
    private static Logger logger = LoggerFactory.getLogger(AntiSpamServiceImpl.class);
    @Autowired
    private PropertiesConfiguration properties;

    @Autowired
    private AntiSpamRecordMapper antiSpamRecordMapper;

    private static HttpClient httpClient = HttpClient4Utils.createHttpClient(100, 20, 2000, 2000, 2000);
    private static HttpClient httpClientImage = HttpClient4Utils.createHttpClient(100, 20, 10000, 2000, 2000);
    @Override
    public PicaResponse processString(Integer userId, String sysCode, String content, boolean isAdFilterOpen) {
        /**
         * 过滤图片
         */
        if (!processImageContent(userId, sysCode, content)) {
            return ReturnUtil.getPicaResponse("400002", "图片包含违禁内容，请修改后重新输入", "");
        }

        Map<String, String> params = new HashMap<String, String>();

        /**
         * 1. 设置公共参数
         */
        params.put("secretId", properties.getNeteaseAntispamSecretId());

        if (!isAdFilterOpen)
            params.put("businessId", properties.getNeteaseAntispamTextBusinessId());
        else
            params.put("businessId", properties.getNeteaseAntispamTextAdBusinessId());

        params.put("version", "v3.1");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce", String.valueOf(new Random().nextInt()));

        /**
         * 2. 设置私有参数
         */
        params.put("dataId", "ebfcad1c-pica-490c-b4de-e784c2691768");
        params.put("content", content);

        /**
         * 3. 生成签名信息
         */
        try {
            String signature = SignatureUtils.genSignature(properties.getNeteaseAntispamSecretKey(), params);
            params.put("signature", signature);
        } catch (UnsupportedEncodingException e) {
            logger.error("processString", e);
        }

        /**
         * 4. 发送HTTP请求
         */
        String response = HttpClient4Utils.sendPost(httpClient, properties.getNeteaseAntispamTextApiUrl(), params, Consts.UTF_8);

        logger.info("content:" +  content + " response=" + response);

        /**
         * 5. 解析返回值
         */
        JsonObject jObject = new JsonParser().parse(response).getAsJsonObject();
        int code = jObject.get("code").getAsInt();
        String msg = jObject.get("msg").getAsString();
        if (code == 200) {
            JsonObject resultObject = jObject.getAsJsonObject("result");
            int action = resultObject.get("action").getAsInt();

            /**
             * label: 100 色情
             * label: 200 广告
             * label: 400 违禁
             * label: 500 涉政
             * label: 600 谩骂
             * label: 700 灌水
             */
            JsonArray labelArray = resultObject.getAsJsonArray("labels");

            /**
             * action: 0 通过
             * action: 1 嫌疑
             * action: 2 不通过
             */
            if (action == 0) {
                insertRecord(userId, sysCode, content, response, (byte)action, 0, "");
            } else {
                StringBuilder hint = new StringBuilder();
                for (JsonElement labelElement : labelArray) {
                    JsonObject lObject = labelElement.getAsJsonObject();
                    int label = lObject.get("label").getAsInt();
                    JsonObject detailsObject=lObject.getAsJsonObject("details");
                    JsonArray hintArray=detailsObject.getAsJsonArray("hint");

                    if (label == 100) msg = "输入内容包含色情词汇，请修改后重新输入";
                    else if (label == 200) msg = "输入内容包含广告词汇，请修改后重新输入";
                    else if (label == 400) msg = "输入内容包含违禁词汇，请修改后重新输入";
                    else if (label == 500) msg = "输入内容包含涉政词汇，请修改后重新输入";
                    else if (label == 600) msg = "输入内容包含谩骂词汇，请修改后重新输入";
                    else if (label == 700) msg = "输入内容包含灌水词汇，请修改后重新输入";

                    for (JsonElement eleHint : hintArray) {
                        hint.append(eleHint.getAsString()).append(",");
                    }
                    if (hint.length() >  0) {
                        hint.deleteCharAt(hint.length() - 1);
                    }
                    if (insertRecord(userId, sysCode, content, response, (byte)action, label, hint.toString()) > 0) {
                        // 确保只插入一次
                        break;
                    }
                }
                return ReturnUtil.getPicaResponse(PicaResultCode.DATA_IS_WRONG.code(), msg, hint.toString());
            }
        } else {
            return ReturnUtil.getPicaResponse(jObject.get("code").getAsString(), msg, "");
        }
        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS, "");
    }

    @Override
    public boolean processImageContent(Integer userId, String sysCode, String content) {
        List<String> imageUrlList = new ArrayList<>();

        /**
         * 如果不包含图片,直接返回
         */
        if (!content.contains("<imgsrc=")) {
            return true;
        }
        int index = -1;
        int end = -1;
        while (-1 != (index = content.indexOf("<imgsrc=\""))) {
            end = content.substring(index, content.length()).indexOf("\">");
            imageUrlList.add(content.substring(index,index + end).replace("<imgsrc=\"", ""));
            content = content.replaceFirst("(<imgsrc[\\s\\S]*?>)", "");
        }

        for (String url : imageUrlList) {
            /**
             * 检测出某张图片失败 则返回
             */
            if (!processImage(userId, sysCode, url)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processImage(Integer userId, String sysCode, String url) {
        Map<String, String> params = new HashMap<String, String>();

        /**
         * 1. 设置公共参数
         */
        params.put("secretId", properties.getNeteaseAntispamSecretId());
        params.put("businessId", properties.getNeteaseAntispamImageBusinessId());
        params.put("version", "v3.2");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("nonce", String.valueOf(new Random().nextInt()));

        /**
         * 2. 设置私有参数
         */
        JsonArray jsonArray = new JsonArray();
        JsonObject image = new JsonObject();
        image.addProperty("name", url);
        image.addProperty("type", 1);
        image.addProperty("data", url);
        jsonArray.add(image);

        params.put("images", jsonArray.toString());
        params.put("account", "picahealth@picahealth.com");

        /**
         * 3. 生成签名信息
         */
        try {
            String signature = SignatureUtils.genSignature(properties.getNeteaseAntispamSecretKey(), params);
            params.put("signature", signature);
        } catch (UnsupportedEncodingException e) {
            logger.error("processImage", e);
        }

        /**
         * 4. 发送HTTP请求
         */
        String response = HttpClient4Utils.sendPost(httpClientImage, properties.getNeteaseAntispamImageApiUrl(), params, Consts.UTF_8);

        /**
         * 5. 解析返回值
         */
        JsonObject resultObject = new JsonParser().parse(response).getAsJsonObject();
        int code = resultObject.get("code").getAsInt();
        String msg = resultObject.get("msg").getAsString();
        if (code == 200) {
            JsonArray resultArray = resultObject.getAsJsonArray("result");
            for (JsonElement jsonElement : resultArray) {
                JsonObject jObject = jsonElement.getAsJsonObject();
                String name = jObject.get("name").getAsString();
                int status = jObject.get("status").getAsInt();
                String taskId = jObject.get("taskId").getAsString();
                JsonArray labelArray = jObject.get("labels").getAsJsonArray();
                logger.info(String.format("taskId=%s，status=%s，name=%s，labels：", taskId, status, name));

                /**
                 * 检测失败 0：成功  610：图片下载失败 620：图片格式错误 630：其他
                 */
                if (status != 0) {
                    continue;
                }

                /**
                 * 100：色情，110：性感，200：广告，210：二维码，300：暴恐，400：违禁，500：涉政
                 */
                int maxLevel = -1;
                double maxRate = 0.0;
                int maxLable = 0;
                // 产品需根据自身需求，自行解析处理，本示例只是简单判断分类级别
                for (JsonElement labelElement : labelArray) {
                    JsonObject lObject = labelElement.getAsJsonObject();
                    int label = lObject.get("label").getAsInt();
                    int level = lObject.get("level").getAsInt();
                    double rate = lObject.get("rate").getAsDouble();
                    if (label == 100 || label == 110 || label == 210) {
                        logger.info(String.format("label:%s, level=%s, rate=%s", label, level, rate));
                        if (level > maxLevel) {
                            maxLevel =  level;
                            maxLable = label;
                        }
                        maxRate = rate > maxRate ? rate : maxRate;
                    }
                }

                if (maxLevel == 2) {
                    insertRecord(userId, sysCode, url, response, (byte)maxLevel, maxLable, "");
                    return false;
                }
            }
        } else {
            logger.error(String.format("ERROR: code=%s, msg=%s", code, msg));
        }
        /**
         * 成功
         */
        insertRecord(userId, sysCode, url, response, (byte)0,0, "");
        return true;
    }

    @Override
    public int insertRecord(Integer userId, String sysCode, String content, String result, Byte action, int label, String hint) {
        AntiSpamRecord antiSpamRecord = new AntiSpamRecord();

        antiSpamRecord.setSysCode(sysCode);
        antiSpamRecord.setContent(content);
        antiSpamRecord.setResult(result);
        antiSpamRecord.setAction(action);

        StringBuilder sb = new StringBuilder();
        sb.append(label);
        antiSpamRecord.setLabel(sb.toString());

        antiSpamRecord.setHint(hint);
        antiSpamRecord.setCreatedId(userId);
        antiSpamRecord.setCreatedTime(new Date());
        antiSpamRecord.setModifiedId(userId);
        antiSpamRecord.setModifiedTime(new Date());
        antiSpamRecord.setIsDeleted(false);

        return antiSpamRecordMapper.insert(antiSpamRecord);
    }
}
