package com.pica.cloud.online.exam.analysis.server.service;

import com.pica.cloud.online.exam.analysis.common.dto.*;
import com.pica.cloud.online.exam.analysis.server.entity.AnalysisRoundExamTitle;
import com.pica.cloud.online.exam.analysis.server.entity.Reply;

import java.util.List;

/**
 * @author wuminghao
 * @date 2018/8/17 9:40
 */
public interface CHCAnalysisService {
    /**
     * 根据活动id获取活动详情
     * @param analysisId
     * @return
     */
    CHCAnalysisDto getCHCAnalysisById(Integer analysisId);


    /**
     * 根据活动id获取活动的轮数
     * @param analysisId
     * @return
     */
    List<AnalysisRoundDto> getRoundListByAnalysisId(Integer analysisId);

    /**
     * 根据轮的id获取信息
     * @param roundId
     * @return
     */
    RoundExamTitleDto getRoundById(Integer roundId);

    /**
     * 根据轮的id获取题目信息
     * @param roundId
     * @return
     */
    List<ExamTitleDto> getExamTitleListByRoundId(Integer roundId);

    /**
     * 获取当前的活动-轮-题目关联表
     * @param analysisRoundExamTitleId
     * @return
     */
    AnalysisRoundExamTitle getAnanlysisRoundExamTitleById(Integer analysisRoundExamTitleId);

    /**
     * 获取考题信息
     * @param analysisRoundExamTitleId
     * @return
     */
    ExamTitleDto getExamTitleDtoById(Integer analysisRoundExamTitleId);

    /**
     * 根据题目id获取回复信息
     * @param analysisRoundExamTitleId
     * @param userId
     * @return
     */
    List<ReplyDto> getReplyListDtoByExamTitleId(Integer analysisRoundExamTitleId, Integer userId);

    /**
     * 根据id获取reply
     * @param replyId
     * @return
     */
    Reply getReplyById(Integer replyId);

    /**
     * 根据reply获取replydto
     * @param reply
     * @param userId
     * @return
     */
    ReplyDto getReplyDtoByReply(Reply reply, Integer userId);

    /**
     * 插入点赞记录
     * @param analysisId
     * @param roundId
     * @param examTitleId
     * @param replyId
     * @return
     */
    Integer insertStarRecord(Integer analysisId, Integer roundId, Integer examTitleId, Integer replyId, Integer userId);

    /**
     * 取消点赞记录
     * @param replyId
     * @param userId
     * @return
     */
    Integer removeStarRecord(Integer replyId, Integer userId);
}
