package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.permission.permission.client.PermissionServiceClient;
import com.pica.cloud.permission.permission.common.annotation.Authentication;
import com.pica.cloud.permission.permission.common.dto.AuthDto;
import com.pica.cloud.permission.permission.common.dto.AuthResultDto;
import com.pica.cloud.permission.permission.common.dto.GrantDto;
import com.pica.cloud.permission.permission.server.service.PermissionCacheService;
import com.pica.cloud.permission.permission.server.service.PermissionService;
import com.pica.cloud.permission.permission.server.validation.PermissionValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Set;


/**
 * @author andong
 * @create 2019/8/29
 */
@Api(description = "权限管理")
@RestController
@RequestMapping("/permission")
public class PermissionController {

    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionCacheService permissionCacheService;
    @Autowired
    private ICacheClient cacheClient;

    @Authentication
    @GetMapping("/test")
    public PicaResponse test(@RequestParam("test") String test, @RequestParam("i") Integer i) {
        return PicaResponse.toResponse(test + i);
    }

    @GetMapping("/cache")
    public PicaResponse cache(@RequestParam("key") String key) {
        Set<String> set = cacheClient.smembers(key);
        return PicaResponse.toResponse(set);
    }

    @ApiOperation("授权")
    @PostMapping("/grant")
    public PicaResponse grant(@RequestBody GrantDto grantDto) {
        PermissionValidation.grantValidate(grantDto);
        permissionService.grant(grantDto);
        return PicaResponse.toResponse();
    }

    @ApiOperation("鉴权")
    @PostMapping("/auth")
    public PicaResponse<AuthResultDto> auth(@RequestBody AuthDto authDto) {
        PermissionValidation.authValidate(authDto);
        AuthResultDto result = permissionService.auth(authDto);
        return PicaResponse.toResponse(result);
    }

    @ApiOperation("初始化角色-资源缓存信息")
    @GetMapping("/init/role-res")
    public PicaResponse initAllRoleResource() {
        permissionCacheService.initAllRoleResource();
        return PicaResponse.toResponse();
    }

    @ApiOperation("初始化用户-角色缓存信息")
    @GetMapping("/init/user")
    public PicaResponse initUserRole(@RequestParam("userId") int userId) {
        permissionCacheService.initUserRole(userId);
        return PicaResponse.toResponse();
    }

}
