package com.pica.cloud.permission.permission.client;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.common.dto.AuthDto;
import com.pica.cloud.permission.permission.common.dto.AuthResultDto;
import com.pica.cloud.permission.permission.common.dto.GrantDto;
import com.pica.cloud.permission.permission.common.dto.UserRoleDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author andong
 * @create 2019/9/9
 */
@FeignClient(name = "13501-pica-cloud-permission")
public interface PermissionServiceClient {

    //授权
    @PostMapping("/permission/permission/user-role")
    PicaResponse grant(@RequestBody UserRoleDto userRoleDto);

    //业务场景授权
    @PostMapping("/permission/permission/grant")
    PicaResponse grant(@RequestBody GrantDto grantDto);

    //取消权限
    @PutMapping("/permission/permission/user-role")
    PicaResponse revoke(@RequestBody UserRoleDto userRoleDto);

    //鉴权
    @PostMapping("/permission/permission/auth")
    PicaResponse<AuthResultDto> auth(@RequestBody AuthDto authDto);
}
