package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.server.entity.Role;
import org.apache.commons.lang.StringUtils;

/**
 * @author andong
 * @create 2019/9/2
 */
public class RoleValidation {

    public static void addRoleValidate(Role role) {
        if (role.getProductType() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型为空");
        }
        if (StringUtils.isBlank(role.getCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色编码为空");
        }
        if (StringUtils.isBlank(role.getName())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色名称为空");
        }
        if (role.getCreatedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }

    public static void updateRoleValidate(Role role) {
        if (role.getId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色ID为空");
        }
        if (role.getModifiedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
        if (StringUtils.isBlank(role.getName())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色名称为空");
        }
    }
}
