package com.pica.cloud.permission.permission.server.exception;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    public static final Logger logger =  LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(Exception.class)
    public PicaResponse defaultErrorHandler(Throwable t){
        if (t instanceof PicaException) {
            PicaException ex = (PicaException) t;
            return PicaResponse.toResponse(null, ex.getCode(), ex.getMsg());
        }
        logger.error(t.getMessage(), t);
        return PicaResponse.toResponse(null, "500005", "服务内部异常");
    }
}