package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.constants.ProductTypeEnum;
import com.pica.cloud.permission.permission.common.constants.ResourceTypeEnum;
import com.pica.cloud.permission.permission.server.entity.Resource;
import org.apache.commons.lang.StringUtils;

/**
 * @author andong
 * @create 2019/8/30
 */
public class ResourceValidation {

    //添加资源校验
    public static void addResourceValidate(Resource resource) {
        Integer productType = resource.getProductType();
        if (productType == null || (productType.intValue() != ProductTypeEnum.DOCTOR.code()
                && productType.intValue() != ProductTypeEnum.HEALTH.code()
                && productType.intValue() != ProductTypeEnum.ADMIN.code())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型不正确");
        }
        if (resource.getCategory() == null || resource.getCategory().intValue() <= 0) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "系统分类不正确");
        }
        Integer type = resource.getType();
        if (type == null || (type.intValue() != ResourceTypeEnum.SYSTEM.code()
                && type.intValue() != ResourceTypeEnum.PAGE.code()
                && type.intValue() != ResourceTypeEnum.MENU.code()
                && type.intValue() != ResourceTypeEnum.BUTTON.code()
                && type.intValue() != ResourceTypeEnum.API.code()
                && type.intValue() != ResourceTypeEnum.FILE.code())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源类型不正确");
        }
        if (StringUtils.isBlank(resource.getCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源编码为空");
        }
        if (StringUtils.isBlank(resource.getName())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源名称为空");
        }
        if (resource.getCreatedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
        if (resource.getType().intValue() == ResourceTypeEnum.API.code() && StringUtils.isBlank(resource.getUrl())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "API资源url不能为空");
        }
    }

    //修改资源校验
    public static void updateResourceValidate(Resource resource) {
        if (resource.getId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源ID为空");
        }
        if (resource.getModifiedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
        if (resource.getCategory() == null && StringUtils.isBlank(resource.getCode())
                && StringUtils.isBlank(resource.getName()) && StringUtils.isBlank(resource.getUrl())
                && resource.getLevel() == null && resource.getParentId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "缺少必要参数");
        }
    }

    //查询资源校验
    public static void queryResourceValidate(Integer productType, Integer category, Integer type, String code, Integer parentId) {
        if (productType == null && category == null && type == null && parentId == null && StringUtils.isBlank(code)) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "缺少查询参数");
        }
    }
}
