package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.permission.permission.common.dto.RoleResourceDto;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.RoleResource;
import com.pica.cloud.permission.permission.server.mapper.RoleResourceMapper;
import com.pica.cloud.permission.permission.server.service.RoleResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Service
public class RoleResourceServiceImpl implements RoleResourceService {

    @Autowired
    private RoleResourceMapper roleResourceMapper;

    @Override
    @Transactional
    public void addRoleResource(RoleResource roleResource) {
        roleResource.setModifiedId(roleResource.getCreatedId());
        roleResource.setCreatedTime(new Date());
        roleResource.setModifiedTime(roleResource.getCreatedTime());
        roleResourceMapper.insertSelective(roleResource);
    }

    @Override
    public List<RoleResourceDto> getByRoleId(int roleId) {
        return roleResourceMapper.getByRoleId(roleId);
    }

    @Override
    @Transactional
    public void deleteRoleResource(int id, int modifiedId) {
        RoleResource roleResource = new RoleResource();
        roleResource.setId(id);
        roleResource.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        roleResource.setModifiedId(modifiedId);
        roleResource.setModifiedTime(new Date());
        roleResourceMapper.updateByPrimaryKeySelective(roleResource);
    }

    @Override
    @Transactional
    public void deleteAll(int roleId, int modifiedId) {
        roleResourceMapper.deleteAll(roleId, modifiedId);
    }
}
