package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.constants.AuthTypeEnum;
import com.pica.cloud.permission.permission.common.dto.AuthDto;
import com.pica.cloud.permission.permission.common.dto.GrantDto;
import org.apache.commons.lang.StringUtils;

/**
 * @author andong
 * @create 2019/9/5
 */
public class PermissionValidation {

    public static void grantValidate(GrantDto grantDto) {
        if (grantDto.getProductType() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型为空");
        }
        if (grantDto.getUserId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID为空");
        }
        if (grantDto.getGrantCode() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "授权场景编码为空");
        }
        if (grantDto.getCreatedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }

    public static void authValidate(AuthDto authDto) {
        if (authDto.getProductType() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型为空");
        }
        if (authDto.getUserId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID为空");
        }
        if (authDto.getAuthType() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "鉴权类型为空");
        }
        if (authDto.getAuthType() == AuthTypeEnum.ROLE && StringUtils.isBlank(authDto.getRoleCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色编码为空");
        }
        if (authDto.getAuthType() == AuthTypeEnum.URL && StringUtils.isBlank(authDto.getUrl())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源url为空");
        }
    }

}
