package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.dto.RoleResourceDto;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import com.pica.cloud.permission.permission.server.entity.Resource;
import com.pica.cloud.permission.permission.server.entity.Role;
import com.pica.cloud.permission.permission.server.entity.RoleResource;
import com.pica.cloud.permission.permission.server.mapper.DataPrivilegeMapper;
import com.pica.cloud.permission.permission.server.mapper.ResourceMapper;
import com.pica.cloud.permission.permission.server.mapper.RoleMapper;
import com.pica.cloud.permission.permission.server.mapper.RoleResourceMapper;
import com.pica.cloud.permission.permission.server.service.PermissionCacheService;
import com.pica.cloud.permission.permission.server.service.RoleResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Service
public class RoleResourceServiceImpl implements RoleResourceService {

    @Autowired
    private PermissionCacheService permissionCacheService;
    @Autowired
    private RoleResourceMapper roleResourceMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private DataPrivilegeMapper dataPrivilegeMapper;

    @Override
    @Transactional
    public void addRoleResource(RoleResource roleResource) {
        Role role = roleMapper.selectByPrimaryKey(roleResource.getRoleId());
        if (role == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "角色ID不存在");
        }
        Resource resource = resourceMapper.selectByPrimaryKey(roleResource.getResourceId());
        if (resource == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "资源ID不存在");
        }
        if (roleResource.getDataPrivilegeId() != null) {
            DataPrivilege dataPrivilege = dataPrivilegeMapper.selectByPrimaryKey(roleResource.getDataPrivilegeId());
            if (dataPrivilege == null) {
                throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "数据权限ID不存在");
            }
            if (dataPrivilege.getResourceId().intValue() != roleResource.getResourceId().intValue()) {
                throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "数据权限与资源不匹配");
            }
        }
        if (role.getProductType().intValue() != resource.getProductType().intValue()) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "角色与资源产品线不匹配");
        }
        Integer pk = roleResourceMapper.checkExist(roleResource);
        if (pk != null) {
            return;  //角色-资源关系已经存在，直接返回
        }

        roleResource.setModifiedId(roleResource.getCreatedId());
        roleResource.setCreatedTime(new Date());
        roleResource.setModifiedTime(roleResource.getCreatedTime());
        roleResourceMapper.insertSelective(roleResource);
        permissionCacheService.addRoleResource(roleResource);  //更新缓存信息
    }

    @Override
    public List<RoleResourceDto> getByRoleId(int roleId) {
        return roleResourceMapper.getByRoleId(roleId);
    }

    @Override
    @Transactional
    public void deleteRoleResource(int id, int modifiedId) {
        RoleResource origin = roleResourceMapper.selectByPrimaryKey(id);
        RoleResource roleResource = new RoleResource();
        roleResource.setId(id);
        roleResource.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        roleResource.setModifiedId(modifiedId);
        roleResource.setModifiedTime(new Date());
        roleResourceMapper.updateByPrimaryKeySelective(roleResource);
        permissionCacheService.deleteRoleResource(origin);  //更新缓存信息
    }

    @Override
    @Transactional
    public void deleteAll(int roleId, int modifiedId) {
        Role role = roleMapper.selectByPrimaryKey(roleId);
        roleResourceMapper.deleteAll(roleId, modifiedId);
        permissionCacheService.deleteAllRoleResource(role);  //更新缓存信息
    }
}
