package com.pica.cloud.permission.permission.server.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;

/**
 * @author andong
 * @create 2019/9/17
 */
@Aspect
@Component
public class PicaLogAspect {

    private static final Logger logger = LoggerFactory.getLogger(PicaLogAspect.class);

    @Pointcut("execution(public * com.pica.cloud..*Controller.*(..))")
    public void weblog() {}

    @Around("weblog()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        String requestBody = "";
        if (!"GET".equalsIgnoreCase(method) && !"DELETE".equalsIgnoreCase(method)) {
            Object[] args = joinPoint.getArgs();
            if (args != null && args.length > 0) {
                requestBody = args[0].toString();
            }
        }
        long startTime = System.currentTimeMillis();
        logger.info("request start, controller params==>, url: {}, method: {}, params: {}, body: {}", url, method, queryString, requestBody);
        Object result = joinPoint.proceed();
        logger.info("request spent time milliSeconds ==>" + (System.currentTimeMillis() - startTime));
        return result;
    }

}
