package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.constants.ProductTypeEnum;
import com.pica.cloud.permission.permission.common.dto.UserRoleDto;
import org.apache.commons.lang.StringUtils;

/**
 * @author andong
 * @create 2019/9/3
 */
public class UserRoleValidation {

    public static void addUserRoleValidate(UserRoleDto userRoleDto) {
        Integer productType = userRoleDto.getProductType();
        if (productType == null || (productType.intValue() != ProductTypeEnum.DOCTOR.code()
                && productType.intValue() != ProductTypeEnum.HEALTH.code()
                && productType.intValue() != ProductTypeEnum.ADMIN.code())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型不正确");
        }
        if (userRoleDto.getUserId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID为空");
        }
        if (userRoleDto.getRoleId() == null && StringUtils.isBlank(userRoleDto.getRoleCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色ID或角色编码为空");
        }
        if (userRoleDto.getCreatedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }

    public static void deleteUserRoleValidate(UserRoleDto userRoleDto) {
        Integer productType = userRoleDto.getProductType();
        if (productType == null || (productType.intValue() != ProductTypeEnum.DOCTOR.code()
                && productType.intValue() != ProductTypeEnum.HEALTH.code()
                && productType.intValue() != ProductTypeEnum.ADMIN.code())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型不正确");
        }
        if (userRoleDto.getUserId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID为空");
        }
        if (userRoleDto.getRoleId() == null && StringUtils.isBlank(userRoleDto.getRoleCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色ID或角色编码为空");
        }
        if (userRoleDto.getModifiedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }
}
