package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.server.entity.Role;
import com.pica.cloud.permission.permission.server.service.RoleService;
import com.pica.cloud.permission.permission.server.validation.RoleValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author andong
 * @create 2019/9/2
 */
@Api(description = "角色管理")
@RestController
@RequestMapping("/permission")
public class RoleController {

    @Autowired
    private RoleService roleService;

    @ApiOperation("根据ID获取角色")
    @GetMapping("/role/{id}")
    public PicaResponse<Role> getById(@PathVariable("id") int id) {
        Role role = roleService.getById(id);
        return PicaResponse.toResponse(role);
    }

    @ApiOperation("根据角色编码或产品线类型获取角色")
    @GetMapping("/role")
    public PicaResponse getByCode(@RequestParam(value = "code", required = false) String code,
                                  @RequestParam(value = "productType", required = false) Integer productType) {
        if (StringUtils.isNotBlank(code)) {
            return PicaResponse.toResponse(roleService.getByCode(code));
        }
        if (productType != null) {
            return PicaResponse.toResponse(roleService.getByProductType(productType));
        }
        throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "缺少查询参数");
    }

    @ApiOperation("添加角色")
    @PostMapping("/role")
    public PicaResponse addRole(@RequestBody Role role) {
        RoleValidation.addRoleValidate(role);
        roleService.addRole(role);
        return PicaResponse.toResponse();
    }

    @ApiOperation("修改角色")
    @PutMapping("/role")
    public PicaResponse updateRole(@RequestBody Role role) {
        RoleValidation.updateRoleValidate(role);
        roleService.updateRole(role);
        return PicaResponse.toResponse();
    }

    @ApiOperation("逻辑删除角色")
    @DeleteMapping("/role")
    public PicaResponse deleteRole(@RequestParam("id") int id, @RequestParam("modifiedId") int modifiedId) {
        roleService.deleteRole(id, modifiedId);
        return PicaResponse.toResponse();
    }

}
