package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.permission.permission.common.constants.AuthTypeEnum;
import com.pica.cloud.permission.permission.common.constants.ProductTypeEnum;
import com.pica.cloud.permission.permission.common.constants.RoleCodeEnum;
import com.pica.cloud.permission.permission.common.dto.*;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.service.PermissionService;
import com.pica.cloud.permission.permission.server.service.UserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author andong
 * @create 2019/9/5
 */
@Service
public class PermissionServiceImpl implements PermissionService {

    @Autowired
    private ICacheClient cacheClient;
    @Autowired
    private UserRoleService userRoleService;

    @Override
    public void grant(GrantDto grantDto) {
        UserRoleDto userRoleDto = new UserRoleDto(ProductTypeEnum.DOCTOR.code(), grantDto.getUserId(), null, grantDto.getCreatedId());
        String grantCode = grantDto.getGrantCode();
        switch (grantCode) {
            case "REGISTER" :
                break;
            case "JOIN_HOSPITAL" :
                break;
            case "QUIT_HOSPITAL" :
                break;
            case "MAIN_ADMIN" :
                userRoleDto.setRoleCode(RoleCodeEnum.MAIN_ADMIN.code());
                userRoleService.addUserRole(userRoleDto);
                break;
            case "ADMIN" :
                userRoleDto.setRoleCode(RoleCodeEnum.ADMIN.code());
                userRoleService.addUserRole(userRoleDto);
                break;
            case "REMOVE_MAIN_ADMIN" :
                userRoleDto.setRoleCode(RoleCodeEnum.MAIN_ADMIN.code());
                userRoleService.deleteUserRole(userRoleDto);
                break;
            case "REMOVE_ADMIN" :
                userRoleDto.setRoleCode(RoleCodeEnum.ADMIN.code());
                userRoleService.deleteUserRole(userRoleDto);
                break;
            case "CERTIFY" :
                break;
        }
    }

    @Override
    public AuthResultDto auth(AuthDto authDto) {
        if (authDto.getAuthType() == AuthTypeEnum.ROLE.code()) {  //判断用户是否具有角色
            if (authDto.getProductType() == ProductTypeEnum.DOCTOR.code()) {
                return this.doctorRoleAuth(authDto);
            } else {
                //TODO
            }
        } else if (authDto.getAuthType() == AuthTypeEnum.URL.code()) {  //判断用户是否具有该url访问权限
            if (authDto.getProductType() == ProductTypeEnum.DOCTOR.code()) {
                return this.doctorUrlAuth(authDto);
            } else {
                //TODO
            }
        }
        return new AuthResultDto(false, null);
    }

    //医生角色鉴权
    private AuthResultDto doctorRoleAuth(AuthDto authDto) {
        for (String roleCode : authDto.getRoleCodes()) {
            boolean access = cacheClient.sismember(Constants.KEY_DOCTOR_ROLE + authDto.getUserId(), roleCode);
            if (access) {
                return new AuthResultDto(true, null);
            }
        }
        return new AuthResultDto(false, null);
    }

    //医生url鉴权
    private AuthResultDto doctorUrlAuth(AuthDto authDto) {
        Set<String> roleCodes = cacheClient.smembers(Constants.KEY_DOCTOR_ROLE + authDto.getUserId());
        if (CollectionUtils.isEmpty(roleCodes)) {  //用户无任何角色
            return new AuthResultDto(false, null);
        }

        if (!authDto.isDataAuth()) {  //仅url鉴权
            for (String roleCode : roleCodes) {
                Set<String> urls = cacheClient.smembers(Constants.KEY_ROLE_URL + roleCode);
                for (String url : urls) {
                    if (authDto.getUrl().equals(url)) {
                        return new AuthResultDto(true, null);
                    }
                }
            }
            return new AuthResultDto(false, null);  //用户无该url访问权限
        } else {  //url+数据权限鉴权
            boolean access = false;
            List<DataPrivilegeDto> list = new ArrayList();
            for (String roleCode : roleCodes) {
                Set<String> urls = cacheClient.smembers(Constants.KEY_ROLE_DATA + roleCode);
                for (String urlData : urls) {
                    String[] datas = urlData.split(Constants.DATA_SPLIT);
                    if (authDto.getUrl().equals(datas[0])) {
                        access = true;
                        if (datas.length == 2) {
                            list.add(new DataPrivilegeDto(datas[1], ""));
                        }
                        if (datas.length == 3) {
                            list.add(new DataPrivilegeDto(datas[1], datas[2]));
                        }
                    }
                }
            }
            return new AuthResultDto(access, list);
        }
    }
}
