package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import com.pica.cloud.permission.permission.server.mapper.DataPrivilegeMapper;
import com.pica.cloud.permission.permission.server.service.DataPrivilegeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Service
public class DataPrivilegeServiceImpl implements DataPrivilegeService {

    @Autowired
    private DataPrivilegeMapper dataPrivilegeMapper;

    @Override
    @Transactional
    public void addDataPrivilege(DataPrivilege dataPrivilege) {
        dataPrivilege.setModifiedId(dataPrivilege.getCreatedId());
        dataPrivilege.setCreatedTime(new Date());
        dataPrivilege.setModifiedTime(dataPrivilege.getCreatedTime());
        dataPrivilegeMapper.insertSelective(dataPrivilege);
    }

    @Override
    public DataPrivilege getById(int id) {
        return dataPrivilegeMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<DataPrivilege> getByResourceId(int resourceId) {
        return dataPrivilegeMapper.getByResourceId(resourceId);
    }

    @Override
    @Transactional
    public void updateDataPrivilege(DataPrivilege dataPrivilege) {
        dataPrivilege.setModifiedTime(new Date());
        dataPrivilegeMapper.updateByPrimaryKeySelective(dataPrivilege);
    }

    @Override
    @Transactional
    public void deleteDataPrivilege(int id, int modifiedId) {
        DataPrivilege dataPrivilege = new DataPrivilege();
        dataPrivilege.setId(id);
        dataPrivilege.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        dataPrivilege.setModifiedId(modifiedId);
        dataPrivilege.setModifiedTime(new Date());
        dataPrivilegeMapper.updateByPrimaryKeySelective(dataPrivilege);
    }
}
