package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.Resource;
import com.pica.cloud.permission.permission.server.mapper.ResourceMapper;
import com.pica.cloud.permission.permission.server.service.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/8/30
 */
@Service
public class ResourceServiceImpl implements ResourceService {

    @Autowired
    private ResourceMapper resourceMapper;

    @Override
    @Transactional
    public void addResource(Resource resource) {
        resource.setModifiedId(resource.getCreatedId());
        resource.setCreatedTime(new Date());
        resource.setModifiedTime(resource.getCreatedTime());
        resourceMapper.insertSelective(resource);
    }

    @Override
    public Resource getById(int id) {
        return resourceMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public void updateResource(Resource resource) {
        resource.setModifiedTime(new Date());
        resourceMapper.updateByPrimaryKeySelective(resource);
    }

    @Override
    public List<Resource> getByCriteria(Resource resource) {
        return resourceMapper.selectByCriteria(resource);
    }

    @Override
    @Transactional
    public void deleteResource(int id, int modifiedId) {
        Resource resource = new Resource();
        resource.setId(id);
        resource.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        resource.setModifiedId(modifiedId);
        resource.setModifiedTime(new Date());
        resourceMapper.updateByPrimaryKeySelective(resource);
    }
}
