package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import com.pica.cloud.permission.permission.server.service.DataPrivilegeService;
import com.pica.cloud.permission.permission.server.validation.DataPrivilegeValidation;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Api(description = "数据权限管理")
@RestController
@RequestMapping("/permission")
public class DataPrivilegeController {

    @Autowired
    private DataPrivilegeService dataPrivilegeService;

    //根据ID获取数据权限
    @GetMapping("/data-privilege/{id}")
    public PicaResponse<DataPrivilege> getById(@PathVariable("id") int id) {
        DataPrivilege dataPrivilege = dataPrivilegeService.getById(id);
        return PicaResponse.toResponse(dataPrivilege);
    }

    //根据资源ID获取数据权限
    @GetMapping("/data-privilege")
    public PicaResponse<List<DataPrivilege>> getByResourceId(@RequestParam("resourceId") int resourceId) {
        List<DataPrivilege> list = dataPrivilegeService.getByResourceId(resourceId);
        return PicaResponse.toResponse(list);
    }

    //添加数据资源
    @PostMapping("/data-privilege")
    public PicaResponse addDataPrivilege(DataPrivilege dataPrivilege) {
        DataPrivilegeValidation.addDataPrivilegeValidate(dataPrivilege);
        dataPrivilegeService.addDataPrivilege(dataPrivilege);
        return PicaResponse.toResponse();
    }

    //修改数据资源
    @PutMapping("/data-privilege")
    public PicaResponse updateDataPrivilege(DataPrivilege dataPrivilege) {
        DataPrivilegeValidation.updateDataPrivilegeValidate(dataPrivilege);
        dataPrivilegeService.updateDataPrivilege(dataPrivilege);
        return PicaResponse.toResponse();
    }

    //逻辑删除数据资源
    @DeleteMapping("/data-privilege")
    public PicaResponse deleteDataPrivilege(@RequestParam("id") int id, @RequestParam("modifiedId") int modifiedId) {
        dataPrivilegeService.deleteDataPrivilege(id, modifiedId);
        return PicaResponse.toResponse();
    }

}
