package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.server.entity.Resource;
import com.pica.cloud.permission.permission.server.service.ResourceService;
import com.pica.cloud.permission.permission.server.validation.ResourceValidation;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author andong
 * @create 2019/8/30
 */
@Api(description = "资源管理")
@RestController
@RequestMapping("/permission")
public class ResourceController {

    @Autowired
    private ResourceService resourceService;

    //根据ID获取资源
    @GetMapping("/resource/{id}")
    public PicaResponse<Resource> getById(@PathVariable("id") int id) {
        Resource resource = resourceService.getById(id);
        return PicaResponse.toResponse(resource);
    }

    //根据条件获取资源
    @GetMapping("/resource")
    public PicaResponse<List<Resource>> getResource(@RequestParam(value = "productType", required = false) Integer productType,
                                              @RequestParam(value = "category", required = false) Integer category,
                                              @RequestParam(value = "type", required = false) Integer type,
                                              @RequestParam(value = "code", required = false) String code,
                                              @RequestParam(value = "parentId", required = false) Integer parentId) {
        ResourceValidation.queryResourceValidate(productType, category, type, code, parentId);
        List<Resource> list = resourceService.getByCriteria(new Resource(productType, category, type, code, parentId));
        return PicaResponse.toResponse(list);
    }

    //添加资源
    @PostMapping("/resource")
    public PicaResponse addResource(@RequestBody Resource resource) {
        ResourceValidation.addResourceValidate(resource);
        resourceService.addResource(resource);
        return PicaResponse.toResponse();
    }

    //修改资源
    @PutMapping("/resource")
    public PicaResponse updateResource(@RequestBody Resource resource) {
        ResourceValidation.updateResourceValidate(resource);
        resourceService.updateResource(resource);
        return PicaResponse.toResponse();
    }

    //根据ID逻辑删除资源
    @DeleteMapping("/resource")
    public PicaResponse deleteResource(@RequestParam("id") int id, @RequestParam("modifiedId") int modifiedId) {
        resourceService.deleteResource(id, modifiedId);
        return PicaResponse.toResponse();
    }


}
