package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.server.entity.RoleResource;
import com.pica.cloud.permission.permission.server.service.RoleResourceService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Api(description = "角色-资源管理")
@RestController
@RequestMapping("/permission")
public class RoleResourceController {

    @Autowired
    private RoleResourceService roleResourceService;

    //根据角色ID获取资源列表
    @GetMapping("/role-resource")
    public PicaResponse<List<RoleResource>> getByRoleId(@RequestParam("roleId") int roleId) {
        List<RoleResource> list = roleResourceService.getByRoleId(roleId);
        return PicaResponse.toResponse(list);
    }

    //添加角色资源关系
    @PostMapping("/role-resource")
    public PicaResponse addRoleResource(@RequestBody RoleResource roleResource) {
        roleResourceService.addRoleResource(roleResource);
        return PicaResponse.toResponse();
    }

    //删除角色资源关系
    @DeleteMapping("/role-resource")
    public PicaResponse deleteRoleResource(@RequestParam(value = "id", required = false) Integer id,
                                           @RequestParam(value = "roleId", required = false) Integer roleId,
                                           @RequestParam("modifiedId") int modifiedId) {
        if (id != null) {
            roleResourceService.deleteRoleResource(id, modifiedId);
        }
        if (roleId != null) {
            roleResourceService.deleteAll(roleId, modifiedId);
        }
        return PicaResponse.toResponse();
    }

}
